const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ConductometriaController = {
  async createConductometria(req, res) {
    try {
      const { Conducto, LongRx, LongTrabajo, IInicial, Referencia, 
        FechaRegistro, EndodonciaId } = req.body;
      const conductometria = await prisma.conductometria.create(
        {
          data: { Conducto, LongRx, LongTrabajo, 
            IInicial, Referencia, 
            FechaRegistro, EndodonciaId }
        }
      );
      // res.json(conductometria);
      res.json(
        {
          status: 'success',
          msj: 'Conductometria creada correctamente',
          data: conductometria
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Conductometria',
          error
        }
      );
    }
  },

  async getAllConductometrias(req, res) {
    try {
      const conductometrias = await prisma.conductometria.findMany();
      if (conductometrias.length > 0) {
        // res.json(conductometrias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Conductometrias',
            data: conductometrias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Conductometrias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Conductometrias',
          error
        }
      );
    }
  },

  async getConductometriaByEndodoncia(req, res) {
    try {
      const { codigo } = req.params;
      const conductometrias = await prisma.conductometria.findMany(
        {
          where: {
            EndodonciaId: parseInt(codigo)
          }
        }
      );
      if (conductometrias.length > 0) {
        // res.json(conductometrias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Conductometrias',
            data: conductometrias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Conductometrias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Conductometrias',
          error
        }
      );
    }
  },

  async getConductometriaById(req, res) {
    try {
      const { id } = req.params;
      const conductometria = await prisma.conductometria.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (conductometria !== null) {
        // res.json(conductometria);
        res.json(
          {
            status: 'success',
            msj: 'Conductometria encontrada',
            data: conductometria
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Conductometria con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Conductometria',
          error
        }
      );
    }
  },

  async updateConductometria(req, res) {
    try {
      const { id } = req.params;
      const { Conducto, LongRx, LongTrabajo, IInicial, Referencia, 
        FechaRegistro, EndodonciaId } = req.body;
      const conductometria = await prisma.conductometria.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Conducto, LongRx, LongTrabajo, 
            IInicial, Referencia, 
            FechaRegistro, EndodonciaId }
        }
      );
      // res.json(conductometria);
      res.json(
        {
          status: 'success',
          msj: 'Conductometria actualizada correctamente',
          data: conductometria
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Conductometria',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Conductometria
  // async deleteConductometria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.conductometria.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Conductometria eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Conductometria',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ConductometriaController;
