const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const EmpresaController = {
  async createEmpresa(req, res) {
    try {
      const { Ruc, RazonSocial, Representante } = req.body;
      const empresa = await prisma.empresa.create(
        {
          data: {
            Ruc,
            RazonSocial,
            Representante
          }
        }
      );
      res.json(empresa);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Empresa creada correctamente',
      //     data: empresa
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la empresa',
          error
        }
      );
    }
  },

  async getAllEmpresas(req, res) {
    try {
      const empresas = await prisma.empresa.findMany();
      if (empresas.length > 0) {
        res.json(empresas);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de empresas',
        //     data: empresas
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay empresas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de empresas',
          error
        }
      );
    }
  },

  async getEmpresaById(req, res) {
    try {
      const { id } = req.params;
      const empresa = await prisma.empresa.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (empresa !== null) {
        res.json(empresa);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Empresa encontrada',
        //     data: empresa
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la empresa con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la empresa',
          error
        }
      );
    }
  },

  async updateEmpresa(req, res) {
    try {
      const { id } = req.params;
      const { Ruc, RazonSocial, Representante } = req.body;
      const empresa = await prisma.empresa.update(
        {
          where: {
            id: parseInt(id)
          },
          data: {
            Ruc,
            RazonSocial,
            Representante
          }
        }
      );
      res.json(empresa);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Empresa actualizada correctamente',
      //     data: empresa
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la empresa',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una empresa
  // async deleteEmpresa(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.empresa.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Empresa eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la empresa',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = EmpresaController;
