const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const EndodonciaController = {
  async createEndodoncia(req, res) {
    try {
      const { Fecha, Docente, Observaciones, Operador, MotivoConsulta, PiezaDental, 
        ECPercucion, ECCavidad, ECCambiodeColor, ECTejidosBlandos, ECTermoreaccion, 
        ECElectroReaccion, ERCavidad, ERTratamientoPrevio, ERPeriodonto, 
        ERLesionesPeriauriculares, ERNumerodeConductos, ERPrecipitacionesCalcicas, 
        STAnestesia, STAAislamientoAbsoluto, FechaRegistro, PacienteId } = req.body;
      const endodoncia = await prisma.endodoncia.create(
        {
          data: { Fecha, Docente, Observaciones, Operador, MotivoConsulta, PiezaDental, 
            ECPercucion, ECCavidad, ECCambiodeColor, ECTejidosBlandos, ECTermoreaccion, 
            ECElectroReaccion, ERCavidad, ERTratamientoPrevio, ERPeriodonto, 
            ERLesionesPeriauriculares, ERNumerodeConductos, ERPrecipitacionesCalcicas, 
            STAnestesia, STAAislamientoAbsoluto, FechaRegistro, PacienteId }
        }
      );
      // res.json(sendodoncia);
      res.json(
        {
          status: 'success',
          msj: 'Endodoncia creada correctamente',
          data: endodoncia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Endodoncia',
          error
        }
      );
    }
  },

  async getAllEndodoncias(req, res) {
    try {
      const endodoncias = await prisma.endodoncia.findMany();
      if (endodoncias.length > 0) {
        // res.json(endodoncias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Endodoncias',
            data: endodoncias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Endodoncias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Endodoncias',
          error
        }
      );
    }
  },

  async getEndodonciaByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const endodoncias = await prisma.endodoncia.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (endodoncias.length > 0) {
        // res.json(endodoncias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Endodoncias',
            data: endodoncias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Endodoncias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Endodoncias',
          error
        }
      );
    }
  },

  async getEndodonciaById(req, res) {
    try {
      const { id } = req.params;
      const endodoncia = await prisma.endodoncia.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (endodoncia !== null) {
        // res.json(endodoncia);
        res.json(
          {
            status: 'success',
            msj: 'Endodoncia encontrada',
            data: endodoncia
          }
        );
      } else {
        console.log(error);
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Endodoncia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Endodoncia',
          error
        }
      );
    }
  },

  async updateEndodoncia(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Docente, Observaciones, Operador, MotivoConsulta, PiezaDental, 
        ECPercucion, ECCavidad, ECCambiodeColor, ECTejidosBlandos, ECTermoreaccion, 
        ECElectroReaccion, ERCavidad, ERTratamientoPrevio, ERPeriodonto, 
        ERLesionesPeriauriculares, ERNumerodeConductos, ERPrecipitacionesCalcicas, 
        STAnestesia, STAAislamientoAbsoluto, FechaRegistro, PacienteId } = req.body;
      const endodoncia = await prisma.endodoncia.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Docente, Observaciones, Operador, MotivoConsulta, PiezaDental, 
            ECPercucion, ECCavidad, ECCambiodeColor, ECTejidosBlandos, ECTermoreaccion, 
            ECElectroReaccion, ERCavidad, ERTratamientoPrevio, ERPeriodonto, 
            ERLesionesPeriauriculares, ERNumerodeConductos, ERPrecipitacionesCalcicas, 
            STAnestesia, STAAislamientoAbsoluto, FechaRegistro, PacienteId }
        }
      );
      // res.json(endodoncia);
      res.json(
        {
          status: 'success',
          msj: 'Endodoncia actualizada correctamente',
          data: endodoncia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Endodoncia',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Endodoncia
  // async deleteEndodoncia(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.endodoncia.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Endodoncia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Endodoncia',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = EndodonciaController;
