const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ExamenEstomatologicoController = {
  async createExamenEstomatologico(req, res) {
    try {
      const { Fecha, Facie, Craneo, Cara, SimetriaTresTercios, SimetriaBilateral, 
        SimetriaPerfil, ATMTrayectoriaAperturayCierre, ATMfluidosdelaATM, ATMpalpitacion, 
        ATMGradodeApertura, Ganglios, EnciaNormal, EnciaFaltaoAusencia, EnciaIncosistencia, 
        ColorNormal, ColorEritematosa, ColorPalida, TexturaNormal, TexturaLisa, TexturaRugosa, 
        ConsistenciaNormal, ConsistenciaEdematosa, ConsistenciaFibrosa, EnciaPapilarNormal, 
        EnciaPapilarAplanada, EnciaPapilarCrateriforme, Encia, MaxilarSuperior, MaxilarInferior, 
        Numero, Color, Forma, Tamanio, Diastemas, ZonasEdentulasyRebordeAlveolar, 
        AlteraciondePosiciones, FacetadeDesgaste, LineaMedia, Otro, LabiosyComisuraLabial, 
        PaladarDuroyBlando, Carrillos, PisodeBoca, Lengua, Orofaringe, Frenillos, Saliva, 
        Temporal, Masetero, PteriogoideoInterno, PteriogoideoExterno, Digastrico, 
        Esternocleidomastoideo, RelacionMolarDerecha, RelacionMolarIzquierda, 
        RelacionCanicaDerecha, RelacionCanicaIzquierda, GradoApertura, OverBite, OverJet, 
        FechaRegistro, PacienteId } = req.body;
      const examenestomatologico = await prisma.examenEstomatologico.create(
        {
          data: { Fecha, Facie, Craneo, Cara, SimetriaTresTercios, SimetriaBilateral, 
            SimetriaPerfil, ATMTrayectoriaAperturayCierre, ATMfluidosdelaATM, ATMpalpitacion, 
            ATMGradodeApertura, Ganglios, EnciaNormal, EnciaFaltaoAusencia, EnciaIncosistencia, 
            ColorNormal, ColorEritematosa, ColorPalida, TexturaNormal, TexturaLisa, TexturaRugosa, 
            ConsistenciaNormal, ConsistenciaEdematosa, ConsistenciaFibrosa, EnciaPapilarNormal, 
            EnciaPapilarAplanada, EnciaPapilarCrateriforme, Encia, MaxilarSuperior, MaxilarInferior, 
            Numero, Color, Forma, Tamanio, Diastemas, ZonasEdentulasyRebordeAlveolar, AlteraciondePosiciones, 
            FacetadeDesgaste, LineaMedia, Otro, LabiosyComisuraLabial, PaladarDuroyBlando, Carrillos, 
            PisodeBoca, Lengua, Orofaringe, Frenillos, Saliva, Temporal, Masetero, PteriogoideoInterno, 
            PteriogoideoExterno, Digastrico, Esternocleidomastoideo, RelacionMolarDerecha, RelacionMolarIzquierda, 
            RelacionCanicaDerecha, RelacionCanicaIzquierda, GradoApertura, OverBite, OverJet, 
            FechaRegistro, PacienteId: parseInt(PacienteId) }
        }
      );
      // res.json(examenestomatologico);
      res.json(
        {
          status: 'success',
          msj: 'ExamenEstomatologico creada correctamente',
          data: examenestomatologico
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Examen Estomatologico',
          error
        }
      );
    }
  },

  async getAllExamenEstomatologicos(req, res) {
    try {
      const examenesestomatologico = await prisma.examenEstomatologico.findMany();
      if (examenesestomatologico.length > 0) {
        // res.json(examenesestomatologico);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ExamenEstomatologicos',
            data: examenesestomatologico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ExamenEstomatologicos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ExamenEstomatologicos',
          error
        }
      );
    }
  },

  async getExamenEstomatologicoByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const examenestomatologico = await prisma.examenEstomatologico.findFirst(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (examenestomatologico !== null) {
        // res.json(examenestomatologico);
        res.json(
          {
            status: 'success',
            msj: 'Examen Estomatologico del Paciente',
            data: examenestomatologico
          }
        );
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de ExamenEstomatologicos',
        //     data: examenesestomatologico
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ExamenEstomatologicos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Examen Estomatologicos',
          error
        }
      );
    }
  },

  async getExamenEstomatologicoById(req, res) {
    try {
      const { id } = req.params;
      const examenestomatologico = await prisma.examenEstomatologico.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (examenestomatologico !== null) {
        // res.json(examenestomatologico);
        res.json(
          {
            status: 'success',
            msj: 'ExamenEstomatologico encontrada',
            data: examenestomatologico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ExamenEstomatologico con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ExamenEstomatologico',
          error
        }
      );
    }
  },

  async updateExamenEstomatologico(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Facie, Craneo, Cara, SimetriaTresTercios, SimetriaBilateral, 
        SimetriaPerfil, ATMTrayectoriaAperturayCierre, ATMfluidosdelaATM, ATMpalpitacion, 
        ATMGradodeApertura, Ganglios, EnciaNormal, EnciaFaltaoAusencia, EnciaIncosistencia, 
        ColorNormal, ColorEritematosa, ColorPalida, TexturaNormal, TexturaLisa, TexturaRugosa, 
        ConsistenciaNormal, ConsistenciaEdematosa, ConsistenciaFibrosa, EnciaPapilarNormal, 
        EnciaPapilarAplanada, EnciaPapilarCrateriforme, Encia, MaxilarSuperior, MaxilarInferior, 
        Numero, Color, Forma, Tamanio, Diastemas, ZonasEdentulasyRebordeAlveolar, 
        AlteraciondePosiciones, FacetadeDesgaste, LineaMedia, Otro, LabiosyComisuraLabial, 
        PaladarDuroyBlando, Carrillos, PisodeBoca, Lengua, Orofaringe, Frenillos, Saliva, 
        Temporal, Masetero, PteriogoideoInterno, PteriogoideoExterno, Digastrico, 
        Esternocleidomastoideo, RelacionMolarDerecha, RelacionMolarIzquierda, 
        RelacionCanicaDerecha, RelacionCanicaIzquierda, GradoApertura, OverBite, OverJet, 
        FechaRegistro, PacienteId } = req.body;
      const examenestomatologico = await prisma.examenEstomatologico.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Facie, Craneo, Cara, SimetriaTresTercios, SimetriaBilateral, 
            SimetriaPerfil, ATMTrayectoriaAperturayCierre, ATMfluidosdelaATM, ATMpalpitacion, 
            ATMGradodeApertura, Ganglios, EnciaNormal, EnciaFaltaoAusencia, EnciaIncosistencia, 
            ColorNormal, ColorEritematosa, ColorPalida, TexturaNormal, TexturaLisa, TexturaRugosa, 
            ConsistenciaNormal, ConsistenciaEdematosa, ConsistenciaFibrosa, EnciaPapilarNormal, 
            EnciaPapilarAplanada, EnciaPapilarCrateriforme, Encia, MaxilarSuperior, MaxilarInferior, 
            Numero, Color, Forma, Tamanio, Diastemas, ZonasEdentulasyRebordeAlveolar, 
            AlteraciondePosiciones, FacetadeDesgaste, LineaMedia, Otro, LabiosyComisuraLabial, 
            PaladarDuroyBlando, Carrillos, PisodeBoca, Lengua, Orofaringe, Frenillos, Saliva, 
            Temporal, Masetero, PteriogoideoInterno, PteriogoideoExterno, Digastrico, 
            Esternocleidomastoideo, RelacionMolarDerecha, RelacionMolarIzquierda, 
            RelacionCanicaDerecha, RelacionCanicaIzquierda, GradoApertura, OverBite, OverJet, 
            FechaRegistro, PacienteId }
        }
      );
      // res.json(examenestomatologico);
      res.json(
        {
          status: 'success',
          msj: 'ExamenEstomatologico actualizada correctamente',
          data: examenestomatologico
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ExamenEstomatologico',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ExamenEstomatologico
  // async deleteExamenEstomatologico(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.examenEstomatologico.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ExamenEstomatologico eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ExamenEstomatologico',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ExamenEstomatologicoController;
