const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ManifestacionEndodonciaController = {
  async createManifestacionEndodoncia(req, res) {
    try {
      const { Nombre, EndodonciaId, ManifestaciondelDolorId } = req.body;
      const manifestacionendodoncia = await prisma.ManifestacionEndodoncia.create(
        {
          data: { Nombre, EndodonciaId, ManifestaciondelDolorId }
        }
      );
      // res.json(manifestacionendodoncia);
      res.json(
        {
          status: 'success',
          msj: 'ManifestacionEndodoncia creada correctamente',
          data: manifestacionendodoncia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la ManifestacionEndodoncia',
          error
        }
      );
    }
  },

  async getAllManifestacionEndodoncias(req, res) {
    try {
      const manifestacionesendodoncia = await prisma.ManifestacionEndodoncia.findMany();
      if (manifestacionesendodoncia.length > 0) {
        // res.json(manifestacionesendodoncia);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ManifestacionEndodoncias',
            data: manifestacionesendodoncia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ManifestacionEndodoncias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ManifestacionEndodoncias',
          error
        }
      );
    }
  },

  async getManifestacionEndodonciaByEndodoncia(req, res) {
    try {
      const { codigo } = req.params;
      const manifestacionesendodoncia = await prisma.ManifestacionEndodoncia.findMany(
        {
          where: {
            EndodonciaId: parseInt(codigo)
          }
        }
      );
      if (manifestacionesendodoncia.length > 0) {
        // res.json(manifestacionesendodoncia);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ManifestacionEndodoncias',
            data: manifestacionesendodoncia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ManifestacionEndodoncias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ManifestacionEndodoncias',
          error
        }
      );
    }
  },

  async getManifestacionEndodonciaById(req, res) {
    try {
      const { id } = req.params;
      const manifestacionendodoncia = await prisma.ManifestacionEndodoncia.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (manifestacionendodoncia !== null) {
        // res.json(manifestacionendodoncia);
        res.json(
          {
            status: 'success',
            msj: 'ManifestacionEndodoncia encontrada',
            data: manifestacionendodoncia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ManifestacionEndodoncia con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ManifestacionEndodoncia',
          error
        }
      );
    }
  },

  async updateManifestacionEndodoncia(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, EndodonciaId, ManifestaciondelDolorId } = req.body;
      const manifestacionendodoncia = await prisma.ManifestacionEndodoncia.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, EndodonciaId, ManifestaciondelDolorId }
        }
      );
      // res.json(manifestacionendodoncia);
      res.json(
        {
          status: 'success',
          msj: 'ManifestacionEndodoncia actualizada correctamente',
          data: manifestacionendodoncia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ManifestacionEndodoncia',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ManifestacionEndodoncia
  // async deleteManifestacionEndodoncia(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.ManifestacionEndodoncia.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ManifestacionEndodoncia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ManifestacionEndodoncia',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ManifestacionEndodonciaController;
