const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const MapeoController = {
  async createMapeo(req, res) {
    try {
      const { OdontogramaId, CasodienteId } = req.body;
      const mapeo = await prisma.mapeo.create(
        {
          data: { OdontogramaId, CasodienteId }
        }
      );
      res.json(mapeo);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Mapeo creada correctamente',
      //     data: mapeo
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Mapeo',
          error
        }
      );
    }
  },

  async getAllMapeos(req, res) {
    try {
      const mapeos = await prisma.mapeo.findMany();
      if (mapeos.length > 0) {
        res.json(mapeos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Mapeos',
        //     data: mapeos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Mapeos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Mapeos',
          error
        }
      );
    }
  },

  async getMapeoByOdontograma(req, res) {
    try {
      const { codigo } = req.params;
      const mapeos = await prisma.mapeo.findMany(
        {
          where: {
            OdontogramaId: parseInt(codigo)
          }
        }
      );
      if (mapeos.length > 0) {
        res.json(mapeos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Mapeos',
        //     data: mapeos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Mapeos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Mapeo',
          error
        }
      );
    }
  },

  async getMapeoById(req, res) {
    try {
      const { id } = req.params;
      const mapeo = await prisma.mapeo.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (mapeo !== null) {
        res.json(mapeo);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Mapeo encontrada',
        //     data: mapeo
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Mapeo con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Mapeo',
          error
        }
      );
    }
  },

  async updateMapeo(req, res) {
    try {
      const { id } = req.params;
      const { OdontogramaId, CasodienteId } = req.body;
      const mapeo = await prisma.mapeo.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { OdontogramaId, CasodienteId }
        }
      );
      res.json(mapeo);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Mapeo actualizada correctamente',
      //     data: mapeo
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Mapeo',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Mapeo
  // async deleteMapeo(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.mapeo.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Mapeo eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Mapeo',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = MapeoController;
