const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PeriodoController = {
  async createPeriodo(req, res) {
    try {
      const { 
        Nombre,
        Empieza,
        Termina,
        SedeId } = req.body;
      const periodo = await prisma.periodo.create(
        {
          data: {
            Nombre,
            Empieza,
            Termina,
            SedeId
          }
        }
      );
      res.json(periodo);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Periodo creada correctamente',
      //     data: periodo
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Periodo',
          err: error
        }
      );
    }
  },

  async getAllPeriodos(req, res) {
    try {
      const periodos = await prisma.periodo.findMany();
      if (periodos.length > 0) {
        res.json(periodos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Periodos',
        //     data: periodos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Periodos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Periodos',
          error
        }
      );
    }
  },

  async sedePeriodo(req, res) {
    try {
      const { codigo } = req.params;
      const periodos = await prisma.periodo.findMany(
        {
          where: {
            SedeId: parseInt(codigo)
          }
        }
      );
      if (periodos.length > 0) {
        res.json(periodos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Periodos de la Sede indicada',
        //     data: periodos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Periodos registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Periodos',
          error
        }
      );
    }
  },

  async getPeriodoById(req, res) {
    try {
      const { id } = req.params;
      const periodo = await prisma.periodo.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (periodo !== null) {
        res.json(periodo);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Periodo encontrada',
        //     data: periodo
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Periodo con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Periodo',
          error
        }
      );
    }
  },

  async updatePeriodo(req, res) {
    try {
      const { id } = req.params;
      const { 
        Nombre,
        Empieza,
        Termina,
        SedeId } = req.body;
      const periodo = await prisma.periodo.update(
        {
          where: {
            id: parseInt(id)
          },
          data: {
            Nombre,
            Empieza,
            Termina,
            SedeId
          }
        }
      );
      res.json(periodo);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Periodo actualizada correctamente',
      //     data: periodo
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Periodo',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Periodo
  // async deletePeriodo(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.periodo.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Periodo eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Periodo',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PeriodoController;
