const express = require('express');
const router = express.Router();
const DocenteController = require('../controllers/docente.controller');

// GET all Docentes
router.get('/', DocenteController.getAllDocentes);

// GET Docente by id
router.get('/:id', DocenteController.getDocenteById);

// POST a new Docente
router.post('/create', DocenteController.createDocente);

// PUT update an existing Docente
router.put('/update/:id', DocenteController.updateDocente);

// DELETE an existing Docente
// muy probable no considerar esta opción
// router.delete('/:id', DocenteController.deleteDocente);

// para los filtros de Docente
router.get('/usuario/:codigo', DocenteController.getDocenteByIdUsuario);

module.exports = router;
