const express = require('express');
const router = express.Router();
const InterpretacionController = require('../controllers/interpretacion.controller');

// GET all Interpretacions
router.get('/', InterpretacionController.getAllInterpretacions);

// GET Interpretacion by id
router.get('/:id', InterpretacionController.getInterpretacionById);

// POST a new Interpretacion
router.post('/create', InterpretacionController.createInterpretacion);

// PUT update an existing Interpretacion
router.put('/update/:id', InterpretacionController.updateInterpretacion);

// DELETE an existing Interpretacion
// muy probable no considerar esta opción
// router.delete('/:id', InterpretacionController.deleteInterpretacion);

// para los filtros de Interpretacion
router.get('/search/paciente/:codigo', InterpretacionController.getInterpretacionByPaciente);

module.exports = router;
