const express = require('express');
const router = express.Router();
const OperatoriaController = require('../controllers/operatoria.controller');

// GET all Operatorias
router.get('/', OperatoriaController.getAllOperatorias);

// GET Operatoria by id
router.get('/:id', OperatoriaController.getOperatoriaById);

// POST a new Operatoria
router.post('/create', OperatoriaController.createOperatoria);

// PUT update an existing Operatoria
router.put('/update/:id', OperatoriaController.updateOperatoria);

// DELETE an existing Operatoria
// muy probable no considerar esta opción
// router.delete('/:id', OperatoriaController.deleteOperatoria);

// para los filtros de Operatoria
router.get('/search/paciente/:codigo', OperatoriaController.getOperatoriaByPaciente);

module.exports = router;
