const express = require('express');
const router = express.Router();
const PacienteController = require('../controllers/paciente.controller');

// GET all Pacientes
router.get('/', PacienteController.getAllPacientes);

// GET Paciente by id
router.get('/:id', PacienteController.getPacienteById);

// POST a new Paciente
router.post('/create', PacienteController.createPaciente);

// PUT update an existing Paciente
router.put('/update/:id', PacienteController.updatePaciente);

// DELETE an existing Paciente
// muy probable no considerar esta opción
// router.delete('/:id', PacienteController.deletePaciente);

// busqueda de los pacientes de la sede
router.get('/search/sede/:codigo', PacienteController.getPacientesBySede);

// busqueda de los pacientes del estudiante
router.get('/search/usuario/:codigo', PacienteController.getPacientesByUsuario);

// busqueda por historia clinica
router.get('/search/historiaclinica/:historiaclinica', PacienteController.getPacienteByNumeroHistoriaClinica);

module.exports = router;
