const express = require('express');
const router = express.Router();
const RadiografiaCirugiaController = require('../controllers/radiografiacirugia.controller');

// GET all RadiografiaCirugias
router.get('/', RadiografiaCirugiaController.getAllRadiografiaCirugias);

// GET RadiografiaCirugia by id
router.get('/:id', RadiografiaCirugiaController.getRadiografiaCirugiaById);

// POST a new RadiografiaCirugia
router.post('/create', RadiografiaCirugiaController.createRadiografiaCirugia);

// PUT update an existing RadiografiaCirugia
router.put('/update/:id', RadiografiaCirugiaController.updateRadiografiaCirugia);

// DELETE an existing RadiografiaCirugia
// muy probable no considerar esta opción
// router.delete('/:id', RadiografiaCirugiaController.deleteRadiografiaCirugia);

// para los filtros de RadiografiaCirugia
router.get('/search/cirugia/:codigo', RadiografiaCirugiaController.getRadiografiaCirugiaByCirugia);

module.exports = router;
