const express = require('express');
const router = express.Router();
const UsuarioController = require('../controllers/usuario.controller');

// GET all Usuarios
router.get('/', UsuarioController.getAllUsuarios);

// GET Usuario by id
router.get('/:id', UsuarioController.getUsuarioById);

// POST a new Usuario
router.post('/create', UsuarioController.createUsuario);

// PUT update an existing Usuario
router.put('/update/:id', UsuarioController.updateUsuario);

// DELETE an existing Usuario
// muy probable no considerar esta opción
// router.delete('/:id', UsuarioController.deleteUsuario);

// para los filtros de Usuario
// para filtrar por sede a los usuarios
router.get('/search/sede/:codigo', UsuarioController.sedeUsuario);

// para filtrar por sede a los administradores
router.get('/search/administrador/:codigo', UsuarioController.administradorUsuario);

// para filtrar por sede a los docentes
router.get('/search/docente/:codigo', UsuarioController.docenteUsuario);

// para filtrar por sede a los estudiantes
router.get('/search/estudiante/:codigo', UsuarioController.estudianteUsuario);

// para filtrar por sede a los usuarios
router.get('/search/rol/:elrol', UsuarioController.rolUsuario);

// para filtrar por condicion a los usuarios
router.get('/search/condicion/:lacondicion', UsuarioController.condicionUsuario);

// para busqueda por correo
router.get('/search/correo/:elcorreo', UsuarioController.getUsuarioByCorreo);

// para busqueda por celular
router.get('/search/celu/:elcelular', UsuarioController.getUsuarioByCelular);

// para busqueda por documento
router.get('/search/documento/:eldocumento', UsuarioController.getUsuarioByDoc);

// para busqueda por documento
router.get('/search/estudiante/celu/:elcelular/:lasede', UsuarioController.getUsuarioEstudianteByCelular);

// para busqueda por documento
router.get('/search/estudiante/documento/:eldocumento/:lasede', UsuarioController.getUsuarioEstudianteByDoc);

// para el logueo con correo
router.get('/loginemail/:correo/:contra', UsuarioController.getUsuarioByLoginEmail);

// para el logueo con celular
router.get('/logincelu/:celular/:contra', UsuarioController.getUsuarioByLoginPhone);

// para comprobar el codigo
router.get('/recover/:codigo/:id', UsuarioController.getUsuarioByRecover);

// para comprobar el codigo
router.put('/recover-password/:id', UsuarioController.updateUsuarioContra);

module.exports = router;
