const cors = require('cors');
const path = require('path');
const logger = require('morgan');
const express = require('express');
const cookieParser = require('cookie-parser');

// const indexRouter = require('./app/routes/index');
// rutas para tablas independientes
const empresaRouter = require('./prisma/routes/empresa.routes');
const cursoRouter = require('./prisma/routes/curso.routes');
const dienteRouter = require('./prisma/routes/diente.routes');
const diagnosticoRouter = require('./prisma/routes/diagnostico.routes');
const casoclinicoRouter = require('./prisma/routes/casoclinico.routes');
// rutas para tablas dependientes
const sedeRouter = require('./prisma/routes/sede.routes');
const periodoRouter = require('./prisma/routes/periodo.routes');
const usuarioRouter = require('./prisma/routes/usuario.routes');
const administradorRouter = require('./prisma/routes/adminstrador.routes');
const docenteRouter = require('./prisma/routes/docente.routes');
const estudianteRouter = require('./prisma/routes/estudiante.routes');
const claseRouter = require('./prisma/routes/clase.routes');
const integranteRouter = require('./prisma/routes/integrante.routes');
const subcasoclinicoRouter = require('./prisma/routes/subcasoclinico.routes');
const casodienteRouter = require('./prisma/routes/casodiente.routes');
const pacienteRouter = require('./prisma/routes/paciente.routes');
const citaRouter = require('./prisma/routes/cita.routes');
const odontogramaRouter = require('./prisma/routes/odontograma.routes');
const mapeoRouter = require('./prisma/routes/mapeo.routes');
const carasdienteRouter = require('./prisma/routes/carasdiente.routes');
const examengeneralRouter = require('./prisma/routes/examengeneral.routes');
const anamnesisRouter = require('./prisma/routes/anamnesis.routes');
const diagnosticopresuntivoRouter = require('./prisma/routes/diagnosticopresuntivo.routes');
const examenesaxuiliaresRouter = require('./prisma/routes/examenauxiliar.routes');
const diagnosticodefinitivoRouter = require('./prisma/routes/diagnosticodefinitivo.routes');
const epicrisisRouter = require('./prisma/routes/epicrisis.routes');
const interpretacionRouter = require('./prisma/routes/interpretacion.routes');
const notasevolutivasRouter = require('./prisma/routes/notasevolutivas.routes');
const planycronogramaRouter = require('./prisma/routes/planycronogramacompleto.routes');
const examenestomatologicoRouter = require('./prisma/routes/examenestomatologico.routes');
const endodonciaRouter = require('./prisma/routes/endodoncia.routes');
const manifestaciondeldolorRouter = require('./prisma/routes/manifestaciondeldolor.routes');
const manifestacionendodonciaRouter = require('./prisma/routes/manifestacionendodoncia.routes');
const conductometriaRouter = require('./prisma/routes/conductometria.routes');
const preparacionquimicomecanicaRouter = require('./prisma/routes/preparacionquimicomecanica.routes');
const obturaciondeconductosRouter = require('./prisma/routes/obturaciondeconductos.routes');
const radiografiaendodonciaRouter = require('./prisma/routes/radiografiaendodoncia.routes');
const operatoriaRouter = require('./prisma/routes/operatoria.routes');
const pruebaRouter = require('./prisma/routes/prueba.routes');
const pruebaoperariaRouter = require('./prisma/routes/pruebaoperaria.routes');
const tecnicaradiograficaRouter = require('./prisma/routes/tecnicaradiografica.routes');
const plandetrabajoRouter = require('./prisma/routes/plandetrabajo.routes');
const cirugiaRouter = require('./prisma/routes/cirugia.routes');
const radiografiacirugiaRouter = require('./prisma/routes/radiografiacirugia.routes');
// const interpretacionradiograficaRouter = require('./prisma/routes/interpretacionradiografia.routes');
const plantratamientoRouter = require('./prisma/routes/plantratamiento.routes');
const informequirurgicoRouter = require('./prisma/routes/informequirurgico.routes');
const estadopostquirurgicoRouter = require('./prisma/routes/estadoposquirurgico.routes');
const concentimientocirugiaRouter = require('./prisma/routes/concentimientocirugia.routes');

const app = express();
app.use(cors());
app.use(express.json());
app.use(
  express.urlencoded(
    {
      extended: false
    }
  )
);
app.use(cookieParser());
app.use(logger('dev'));

// Set up a more restrictive CORS policy with a list of allowed URLs
// const allowedOrigins = [
//     'https://example.com',
//     'https://subdomain.example.com'
// ];
// app.use(function(req, res, next) {
//     const origin = req.headers.origin;
//     if (allowedOrigins.includes(origin)) {
//         res.header("Access-Control-Allow-Origin", origin);
//     }
//     res.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
//     res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
//     next();
// });

// Capture the client's IP address
// app.use(function(req, res, next) {
//     const clientIp = req.headers['x-forwarded-for'] || req.connection.remoteAddress;
//     console.log(`Client IP address: ${clientIp}`);
//     next();
// });

app.use(
  '/',
  express.static(
    path.join(
      __dirname,
      'public'
    )
  )
);

// app.use(
//   '/live',
//   indexRouter
// );
// ruta de tablas independientes
app.use(
  '/empresas',
  empresaRouter
);
app.use(
  '/cursos',
  cursoRouter
);
app.use(
  '/diente',
  dienteRouter
);
app.use(
  '/diagnostico',
  diagnosticoRouter
);
app.use(
  '/casoclinico',
  casoclinicoRouter
);
// ruta de tablas dependientes
app.use(
  '/sedes',
  sedeRouter
);
app.use(
  '/periodos',
  periodoRouter
);
app.use(
  '/administrador',
  administradorRouter
);
app.use(
  '/docente',
  docenteRouter
);
app.use(
  '/estudiante',
  estudianteRouter
);
app.use(
  '/clase',
  claseRouter
);
app.use(
  '/integrante',
  integranteRouter
);
app.use(
  '/subcasoclinico',
  subcasoclinicoRouter
);
app.use(
  '/casodiente',
  casodienteRouter
);
app.use(
  '/odontograma',
  odontogramaRouter
);
app.use(
  '/mapeo',
  mapeoRouter
);
app.use(
  '/carasdiente',
  carasdienteRouter
);
app.use(
  '/cita',
  citaRouter
);
app.use(
  '/examengeneral',
  examengeneralRouter
);
app.use(
  '/anamnesis',
  anamnesisRouter
);
app.use(
  '/diagnosticopresuntivo',
  diagnosticopresuntivoRouter
);
app.use(
  '/examenesauxiliares',
  examenesaxuiliaresRouter
);
app.use(
  '/diagnosticodefinitivo',
  diagnosticodefinitivoRouter
);
app.use(
  '/epicrisis',
  epicrisisRouter
);
app.use(
  '/interpretacion',
  interpretacionRouter
);
app.use(
  '/notaevolutiva',
  notasevolutivasRouter
);
app.use(
  '/planycronograma',
  planycronogramaRouter
);
app.use(
  '/examenestomatologico',
  examenestomatologicoRouter
);
app.use(
  '/endodoncia',
  endodonciaRouter
);
app.use(
  '/manifestaciondeldolor',
  manifestaciondeldolorRouter
);
app.use(
  '/manifestacionendodoncia',
  manifestacionendodonciaRouter
);
app.use(
  '/conductometria',
  conductometriaRouter
);
app.use(
  '/preparacionquimicomecanica',
  preparacionquimicomecanicaRouter
);
app.use(
  '/obturaciondeconductos',
  obturaciondeconductosRouter
);
app.use(
  '/radiografiaendodoncia',
  radiografiaendodonciaRouter
);
app.use(
  '/operatorio',
  operatoriaRouter
);
app.use(
  '/prueba',
  pruebaRouter
);
app.use(
  '/pruebaoperaria',
  pruebaoperariaRouter
);
app.use(
  '/tecnicaradiografica',
  tecnicaradiograficaRouter
);
app.use(
  '/plandetrabajo',
  plandetrabajoRouter
);
app.use(
  '/cirugia',
  cirugiaRouter
);
app.use(
  '/radiografiacirugia',
  radiografiacirugiaRouter
);
// app.use(
//   '/interpretacionradiografica',
//   interpretacionradiograficaRouter
// );
app.use(
  '/plantratamiento',
  plantratamientoRouter
);
app.use(
  '/informequirurgico',
  informequirurgicoRouter
);
app.use(
  '/estadoposquirurgico',
  estadopostquirurgicoRouter
);
app.use(
  '/concentimiento',
  concentimientocirugiaRouter
);
// la ruta que tiene que tener seguridad
app.use(
  '/usuario',
  usuarioRouter
);
app.use(
  '/paciente',
  pacienteRouter
);

module.exports = app;

