const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const AdministradorController = {
  async createAdministrador(req, res) {
    try {
      const { NombreCompleto, CodigoAcceso, UsuarioId } = req.body;
      const administrador = await prisma.administrador.create(
        {
          data: { NombreCompleto, CodigoAcceso, UsuarioId }
        }
      );
      res.json(administrador);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Administrador creada correctamente',
      //     data: administrador
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Administrador',
          error
        }
      );
    }
  },

  async getAllAdministradors(req, res) {
    try {
      const administradores = await prisma.administrador.findMany();
      if (administradores.length > 0) {
        res.json(administradores);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Administradors',
        //     data: administradores
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Administradors registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Administradors',
          error
        }
      );
    }
  },

  async getAdministradorByIdUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const administrador = await prisma.administrador.findFirst(
        {
          where: {
            UsuarioId: parseInt(codigo)
          }
        }
      );
      if (administrador !== null) {
        res.json(administrador);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Administrador encontrada',
        //     data: administrador
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Administrador con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener al Administrador',
          error: error
        }
      );
    }
  },

  async getAdministradorById(req, res) {
    try {
      const { id } = req.params;
      const administrador = await prisma.administrador.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      // res.json(Administrador)
      if (administrador !== null) {
        res.json(administrador);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Administrador encontrada',
        //     data: administrador
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Administrador con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Administrador',
          error
        }
      );
    }
  },

  async updateAdministrador(req, res) {
    try {
      const { id } = req.params;
      const { NombreCompleto, CodigoAcceso, UsuarioId } = req.body;
      const administrador = await prisma.administrador.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { NombreCompleto, CodigoAcceso, UsuarioId }
        }
      );
      res.json(administrador);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Administrador actualizada correctamente',
      //     data: administrador
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Administrador',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Administrador
  // async deleteAdministrador(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.administrador.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Administrador eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Administrador',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = AdministradorController;
