const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const AnamnesisController = {
  async createAnamnesis(req, res) {
    try {
      const { Contenido, FechaRegistro, PacienteId } = req.body;
      const anamnesis = await prisma.anamnesis.create(
        {
          data: { Contenido, FechaRegistro, PacienteId }
        }
      );
      // res.json(anamnesis);
      res.json(
        {
          status: 'success',
          msj: 'Anamnesis creada correctamente',
          data: anamnesis
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Anamnesis',
          error
        }
      );
    }
  },

  async getAllAnamnesiss(req, res) {
    try {
      const anamnesis = await prisma.anamnesis.findMany();
      if (anamnesis.length > 0) {
        // res.json(anamnesis);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Anamnesiss',
            data: anamnesis
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Anamnesiss registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Anamnesiss',
          error
        }
      );
    }
  },

  async getAnamnesisByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const anamnesis = await prisma.anamnesis.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (anamnesis.length > 0) {
        // res.json(anamnesis);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Anamnesiss',
            data: anamnesis
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Anamnesiss registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Anamnesiss',
          error
        }
      );
    }
  },

  async getAnamnesisById(req, res) {
    try {
      const { id } = req.params;
      const anamnesis = await prisma.anamnesis.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (Anamnesis !== null) {
        // res.json(anamnesis);
        res.json(
          {
            status: 'success',
            msj: 'Anamnesis encontrada',
            data: anamnesis
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Anamnesis con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Anamnesis',
          error
        }
      );
    }
  },

  async updateAnamnesis(req, res) {
    try {
      const { id } = req.params;
      const { Contenido, FechaRegistro, PacienteId } = req.body;
      const anamnesis = await prisma.anamnesis.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Contenido, FechaRegistro, PacienteId }
        }
      );
      // res.json(anamnesis);
      res.json(
        {
          status: 'success',
          msj: 'Anamnesis actualizada correctamente',
          data: anamnesis
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Anamnesis',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Anamnesis
  // async deleteAnamnesis(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.anamnesis.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Anamnesis eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Anamnesis',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = AnamnesisController;
