const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const CaraDienteController = {
  async createCaraDiente(req, res) {
    try {
      const { Mesial, Distal, Vestibular, Lingual, Palatina, MapeoId } = req.body;
      const caradiente = await prisma.carasDiente.create(
        {
          data: { Mesial, Distal, Vestibular, Lingual, Palatina, MapeoId }
        }
      );
      res.json(caradiente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'CaraDiente creada correctamente',
      //     data: caradiente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la CaraDiente',
          err: error
        }
      );
    }
  },

  async getAllCaraDientes(req, res) {
    try {
      const carasdiente = await prisma.carasDiente.findMany();
      if (carasdiente.length > 0) {
        res.json(carasdiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de CaraDientes',
        //     data: carasdiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay CaraDientes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de CaraDientes',
          error: error
        }
      );
    }
  },

  async getCaraDienteByMapeo(req, res) {
    try {
      const { codigo } = req.params;
      const carasdiente = await prisma.carasDiente.findMany(
        {
          where: {
            MapeoId: parseInt(codigo)
          }
        }
      );
      if (carasdiente.length > 0) {
        res.json(carasdiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de CaraDientes',
        //     data: carasdiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay CaraDientes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la CaraDiente',
          error
        }
      );
    }
  },

  async getCaraDienteById(req, res) {
    try {
      const { id } = req.params;
      const caradiente = await prisma.carasDiente.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (caradiente !== null) {
        res.json(caradiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'CaraDiente encontrada',
        //     data: caradiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la CaraDiente con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la CaraDiente',
          error
        }
      );
    }
  },

  async updateCaraDiente(req, res) {
    try {
      const { id } = req.params;
      const { Mesial, Distal, Vestibular, Lingual, Palatina, MapeoId } = req.body;
      const caradiente = await prisma.carasDiente.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Mesial, Distal, Vestibular, Lingual, Palatina, MapeoId }
        }
      );
      res.json(caradiente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'CaraDiente actualizada correctamente',
      //     data: caradiente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la CaraDiente',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una CaraDiente
  // async deleteCaraDiente(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.carasDiente.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'CaraDiente eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la CaraDiente',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = CaraDienteController;
