const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const CasoClinicoController = {
  async createCasoClinico(req, res) {
    try {
      const { Nombre } = req.body;
      const casoclinico = await prisma.casoClinico.create(
        {
          data: {
            Nombre
          }
        }
      );
      res.json(casoclinico);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'CasoClinico creada correctamente',
      //     data: casoclinico
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la CasoClinico',
          error
        }
      );
    }
  },

  async getAllCasoClinicos(req, res) {
    try {
      const casosclinicos = await prisma.casoClinico.findMany();
      // res.json(casosclinicos)
      if (casosclinicos.length > 0) {
        res.json(casosclinicos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de CasoClinicos',
        //     data: casosclinicos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay CasoClinicos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de CasoClinicos',
          error
        }
      );
    }
  },

  async getCasoClinicoById(req, res) {
    try {
      const { id } = req.params;
      const casoclinico = await prisma.casoClinico.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (casoclinico !== null) {
        res.json(casoclinico);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'CasoClinico encontrada',
        //     data: casoclinico
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la CasoClinico con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la CasoClinico',
          error
        }
      );
    }
  },

  async updateCasoClinico(req, res) {
    try {
      const { id } = req.params;
      const { Nombre } = req.body;
      const casoclinico = await prisma.casoClinico.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre }
        }
      );
      res.json(casoclinico);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'CasoClinico actualizada correctamente',
      //     data: casoclinico
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la CasoClinico',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una CasoClinico
  // async deleteCasoClinico(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.casoClinico.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'CasoClinico eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la CasoClinico',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = CasoClinicoController;
