const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const CirugiaController = {
  async createCirugia(req, res) {
    try {
      const { MotivoConsulta, DiagnosticoCIE11, Pronostico, PlandeTrabajo, 
        Cirujano, Asistente, Circulante, HoradeInicioCx, HoradeTerminoCx, 
        FechaAlta, Observaciones, EvolucionDiaria, EstudianteaCargo, 
        FacultativoaCargo, FechaRegistro, PacienteId } = req.body;
      const cirugia = await prisma.cirugia.create(
        {
          data: { MotivoConsulta, DiagnosticoCIE11, Pronostico, PlandeTrabajo, 
            Cirujano, Asistente, Circulante, HoradeInicioCx, HoradeTerminoCx, 
            FechaAlta, Observaciones, EvolucionDiaria, EstudianteaCargo, 
            FacultativoaCargo, FechaRegistro, PacienteId }
        }
      );
      // res.json(cirugia);
      res.json(
        {
          status: 'success',
          msj: 'Cirugia creada correctamente',
          data: cirugia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Cirugia',
          error
        }
      );
    }
  },

  async getAllCirugias(req, res) {
    try {
      const cirugias = await prisma.cirugia.findMany();
      if (cirugias.length > 0) {
        // res.json(cirugias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Cirugias',
            data: cirugias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Cirugias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Cirugias',
          error
        }
      );
    }
  },

  async getCirugiaByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const cirugias = await prisma.cirugia.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (cirugias.length > 0) {
        // res.json(cirugias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Cirugias',
            data: cirugias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Cirugias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Cirugias',
          error
        }
      );
    }
  },

  async getCirugiaById(req, res) {
    try {
      const { id } = req.params;
      const cirugia = await prisma.cirugia.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (cirugia !== null) {
        // res.json(cirugia);
        res.json(
          {
            status: 'success',
            msj: 'Cirugia encontrada',
            data: cirugia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Cirugia con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Cirugia',
          error
        }
      );
    }
  },

  async updateCirugia(req, res) {
    try {
      const { id } = req.params;
      const { MotivoConsulta, DiagnosticoCIE11, Pronostico, PlandeTrabajo, 
        Cirujano, Asistente, Circulante, HoradeInicioCx, HoradeTerminoCx, 
        FechaAlta, Observaciones, EvolucionDiaria, EstudianteaCargo, 
        FacultativoaCargo, FechaRegistro, PacienteId } = req.body;
      const cirugia = await prisma.cirugia.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { MotivoConsulta, DiagnosticoCIE11, Pronostico, PlandeTrabajo, 
            Cirujano, Asistente, Circulante, HoradeInicioCx, HoradeTerminoCx, 
            FechaAlta, Observaciones, EvolucionDiaria, EstudianteaCargo, 
            FacultativoaCargo, FechaRegistro, PacienteId }
        }
      );
      // res.json(cirugia);
      res.json(
        {
          status: 'success',
          msj: 'Cirugia actualizada correctamente',
          data: cirugia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Cirugia',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Cirugia
  // async deleteCirugia(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.cirugia.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Cirugia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Cirugia',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = CirugiaController;
