const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ConcentimientoCirugiaController = {
  async createConcentimientoCirugia(req, res) {
    try {
      const { Fecha, Odontologo, Tipo, 
        FirmaOdontologo, FirmaEstudiante, 
        FirmaPaciente, FechaRegistro, 
        CirugiaId } = req.body;
      const concentimiento = await prisma.concentimientoCirugia.create(
        {
          data: { Fecha, Odontologo, Tipo, FirmaOdontologo, FirmaEstudiante, 
            FirmaPaciente, FechaRegistro, CirugiaId }
        }
      );
      // res.json(Concentimientocirugia);
      res.json(
        {
          status: 'success',
          msj: 'ConcentimientoCirugia creada correctamente',
          data: concentimiento
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la ConcentimientoCirugia',
          error
        }
      );
    }
  },

  async getAllConcentimientoCirugias(req, res) {
    try {
      const concentimientos = await prisma.concentimientoCirugia.findMany();
      if (concentimientos.length > 0) {
        // res.json(concentimientos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ConcentimientoCirugias',
            data: concentimientos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ConcentimientoCirugias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ConcentimientoCirugias',
          error
        }
      );
    }
  },

  async getConcentimientoCirugiaByCirugia(req, res) {
    try {
      const { codigo } = req.params;
      const concentimientos = await prisma.concentimientoCirugia.findMany(
        {
          where: {
            CirugiaId: parseInt(codigo)
          }
        }
      );
      if (concentimientos.length > 0) {
        // res.json(concentimientos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ConcentimientoCirugias',
            data: concentimientos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ConcentimientoCirugias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ConcentimientoCirugias',
          error
        }
      );
    }
  },

  async getConcentimientoCirugiaById(req, res) {
    try {
      const { id } = req.params;
      const concentimiento = await prisma.concentimientoCirugia.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (concentimiento !== null) {
        // res.json(Concentimientocirugia);
        res.json(
          {
            status: 'success',
            msj: 'ConcentimientoCirugia encontrada',
            data: concentimiento
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ConcentimientoCirugia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ConcentimientoCirugia',
          error
        }
      );
    }
  },

  async updateConcentimientoCirugia(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Odontologo, Tipo, 
        FirmaOdontologo, FirmaEstudiante, 
        FirmaPaciente, FechaRegistro, 
        CirugiaId } = req.body;
      const concentimiento = await prisma.concentimientoCirugia.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Odontologo, Tipo, FirmaOdontologo, FirmaEstudiante, 
            FirmaPaciente, FechaRegistro, CirugiaId }
        }
      );
      // res.json(Concentimientocirugia);
      res.json(
        {
          status: 'success',
          msj: 'ConcentimientoCirugia actualizada correctamente',
          data: concentimiento
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ConcentimientoCirugia',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ConcentimientoCirugia
  // async deleteConcentimientoCirugia(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.concentimientoCirugia.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ConcentimientoCirugia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ConcentimientoCirugia',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ConcentimientoCirugiaController;
