const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const DiagnosticoController = {
  async createDiagnostico(req, res) {
    try {
      const { Tipo, Codigo, Resumen, Descripcion } = req.body;
      const diagnostico = await prisma.diagnostico.create(
        {
          data: { Tipo, Codigo, Resumen, Descripcion }
        }
      );
      // res.json(diagnostico);
      res.json(
        {
          status: 'success',
          msj: 'Diagnostico creada correctamente',
          data: diagnostico
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Diagnostico',
          error
        }
      );
    }
  },

  async getAllDiagnosticos(req, res) {
    try {
      const diagnosticos = await prisma.diagnostico.findMany();
      if (diagnosticos.length > 0) {
        // res.json(diagnosticos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Diagnosticos',
            data: diagnosticos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Diagnosticos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Diagnosticos',
          err: error
        }
      );
    }
  },

  async getDiagnosticoById(req, res) {
    try {
      const { id } = req.params;
      const diagnostico = await prisma.diagnostico.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (diagnostico !== null) {
        // res.json(diagnostico);
        res.json(
          {
            status: 'success',
            msj: 'Diagnostico encontrada',
            data: diagnostico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Diagnostico con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Diagnostico',
          error
        }
      );
    }
  },

  async updateDiagnostico(req, res) {
    try {
      const { id } = req.params;
      const { Tipo, Codigo, Resumen, Descripcion } = req.body;
      const diagnostico = await prisma.diagnostico.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Tipo, Codigo, Resumen, Descripcion }
        }
      );
      // res.json(diagnostico);
      res.json(
        { 
          status: 'success',
          msj: 'Diagnostico actualizada correctamente',
          data: diagnostico
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Diagnostico',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Diagnostico
  // async deleteDiagnostico(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.diagnostico.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Diagnostico eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Diagnostico',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = DiagnosticoController;
