const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const DiagnosticoDefinitivoController = {
  async createDiagnosticoDefinitivo(req, res) {
    try {
      const { Diagnostico, FechaRegistro, PacienteId } = req.body;
      const diagnosticodefinitivo = await prisma.diagnosticoDefinitivo.create(
        {
          data: { Diagnostico, FechaRegistro, PacienteId }
        }
      );
      // res.json(diagnosticodefinitivo);
      res.json(
        {
          status: 'success',
          msj: 'DiagnosticoDefinitivo creada correctamente',
          data: diagnosticodefinitivo
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la DiagnosticoDefinitivo',
          error
        }
      );
    }
  },

  async getAllDiagnosticoDefinitivos(req, res) {
    try {
      const diagnosticosdefinitivos = await prisma.diagnosticoDefinitivo.findMany();
      if (diagnosticosdefinitivos.length > 0) {
        // res.json(diagnosticosdefinitivos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de DiagnosticoDefinitivos',
            data: diagnosticosdefinitivos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay DiagnosticoDefinitivos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de DiagnosticoDefinitivos',
          error
        }
      );
    }
  },

  async getDiagnosticoDefinitivoByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const diagnosticosdefinitivos = await prisma.diagnosticoDefinitivo.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (diagnosticosdefinitivos.length > 0) {
        // res.json(diagnosticosdefinitivos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de DiagnosticoDefinitivos',
            data: diagnosticosdefinitivos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay DiagnosticoDefinitivos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de DiagnosticoDefinitivos',
          error
        }
      );
    }
  },

  async getDiagnosticoDefinitivoById(req, res) {
    try {
      const { id } = req.params;
      const diagnosticodefinitivo = await prisma.diagnosticoDefinitivo.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (diagnosticodefinitivo !== null) {
        // res.json(diagnosticodefinitivo);
        res.json(
          {
            status: 'success',
            msj: 'DiagnosticoDefinitivo encontrada',
            data: diagnosticodefinitivo
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la DiagnosticoDefinitivo con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la DiagnosticoDefinitivo',
          error
        }
      );
    }
  },

  async updateDiagnosticoDefinitivo(req, res) {
    try {
      const { id } = req.params;
      const { Diagnostico, FechaRegistro, PacienteId } = req.body;
      const diagnosticodefinitivo = await prisma.diagnosticoDefinitivo.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Diagnostico, FechaRegistro, PacienteId }
        }
      );
      // res.json(diagnosticodefinitivo);
      res.json(
        {
          status: 'success',
          msj: 'DiagnosticoDefinitivo actualizada correctamente',
          data: diagnosticodefinitivo
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la DiagnosticoDefinitivo',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una DiagnosticoDefinitivo
  // async deleteDiagnosticoDefinitivo(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.diagnosticoDefinitivo.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'DiagnosticoDefinitivo eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la DiagnosticoDefinitivo',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = DiagnosticoDefinitivoController;
