const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const DiagnosticoPresuntivoController = {
  async createDiagnosticoPresuntivo(req, res) {
    try {
      const { Diagnostico, FechaRegistro, PacienteId } = req.body;
      const diagnosticopresuntivo = await prisma.diagnosticoPresuntivo.create(
        {
          data: { Diagnostico, FechaRegistro, PacienteId }
        }
      );
      // res.json(diagnosticopresuntivo);
      res.json(
        {
          status: 'success',
          msj: 'DiagnosticoPresuntivo creada correctamente',
          data: diagnosticopresuntivo
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la DiagnosticoPresuntivo',
          error: error
        }
      );
    }
  },

  async getAllDiagnosticoPresuntivos(req, res) {
    try {
      const diagnosticospresuntivos = await prisma.diagnosticoPresuntivo.findMany();
      if (diagnosticospresuntivos.length > 0) {
        // res.json(diagnosticospresuntivos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de DiagnosticoPresuntivos',
            data: diagnosticospresuntivos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay DiagnosticoPresuntivos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de DiagnosticoPresuntivos',
          error
        }
      );
    }
  },

  async getDiagnosticoPresuntivoByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const diagnosticospresuntivos = await prisma.diagnosticoPresuntivo.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (diagnosticospresuntivos.length > 0) {
        // res.json(diagnosticospresuntivos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de DiagnosticoPresuntivos',
            data: diagnosticospresuntivos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay DiagnosticoPresuntivos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de DiagnosticoPresuntivos',
          error
        }
      );
    }
  },

  async getDiagnosticoPresuntivoById(req, res) {
    try {
      const { id } = req.params;
      const diagnosticopresuntivo = await prisma.diagnosticoPresuntivo.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (diagnosticopresuntivo !== null) {
        // res.json(diagnosticopresuntivo);
        res.json(
          {
            status: 'success',
            msj: 'DiagnosticoPresuntivo encontrada',
            data: diagnosticopresuntivo
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la DiagnosticoPresuntivo con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la DiagnosticoPresuntivo',
          error
        }
      );
    }
  },

  async updateDiagnosticoPresuntivo(req, res) {
    try {
      const { id } = req.params;
      const { Diagnostico, FechaRegistro, PacienteId } = req.body;
      const diagnosticopresuntivo = await prisma.diagnosticoPresuntivo.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Diagnostico, FechaRegistro, PacienteId }
        }
      );
      // res.json(diagnosticopresuntivo);
      res.json(
        {
          status: 'success',
          msj: 'DiagnosticoPresuntivo actualizada correctamente',
          data: diagnosticopresuntivo
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la DiagnosticoPresuntivo',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una DiagnosticoPresuntivo
  // async deleteDiagnosticoPresuntivo(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.diagnosticoPresuntivo.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'DiagnosticoPresuntivo eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la DiagnosticoPresuntivo',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = DiagnosticoPresuntivoController;
