const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const DienteController = {
  async createDiente(req, res) {
    try {
      const { Nombre, Ubicacion, Tipo, Lado, Posicion, Raiz, Estado } = req.body;
      const diente = await prisma.diente.create(
        {
          data: { Nombre, Ubicacion, Tipo, Lado, Posicion, Raiz, Estado }
        }
      );
      res.json(diente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Diente creada correctamente',
      //     data: diente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Diente',
          error
        }
      );
    }
  },

  async getAllDientes(req, res) {
    try {
      const dientes = await prisma.diente.findMany();
      if (dientes.length > 0) {
        res.json(dientes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Dientes',
        //     data: dientes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Dientes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Dientes',
          error
        }
      );
    }
  },

  async getDienteById(req, res) {
    try {
      const { id } = req.params;
      const diente = await prisma.diente.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (diente !== null) {
        res.json(diente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Diente encontrada',
        //     data: diente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Diente con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Diente',
          error
        }
      );
    }
  },

  async updateDiente(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Ubicacion, Tipo, Lado, Posicion, Raiz, Estado } = req.body;
      const diente = await prisma.diente.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Ubicacion, Tipo, Lado, Posicion, Raiz, Estado }
        }
      );
      res.json(diente);
      // res.json(
      //   { 
      //     status: 'success',
      //     msj: 'Diente actualizada correctamente',
      //     data: diente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Diente',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Diente
  // async deleteDiente(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.diente.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Diente eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Diente',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = DienteController;
