const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const DocenteController = {
  async createDocente(req, res) {
    try {
      const { NombreCompleto, Colegiatura, FirmaDigital, UsuarioId } = req.body;
      const docente = await prisma.docente.create(
        {
          data: { NombreCompleto, Colegiatura, FirmaDigital, UsuarioId }
        }
      );
      res.json(docente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Docente creada correctamente',
      //     data: docente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Docente',
          error
        }
      );
    }
  },

  async getAllDocentes(req, res) {
    try {
      const docentes = await prisma.docente.findMany();
      if (docentes.length > 0) {
        res.json(docentes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Docentes',
        //     data: docentes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Docentes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Docentes',
          error
        }
      );
    }
  },

  async getDocenteByIdUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const docente = await prisma.docente.findFirst(
        {
          where: {
            UsuarioId: parseInt(codigo)
          }
        }
      );
      // res.json(Docentes)
      if (docente !== null) {
        res.json(docente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Docente encontrada',
        //     data: docente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Docente con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Docente',
          error
        }
      );
    }
  },

  async getDocenteById(req, res) {
    try {
      const { id } = req.params;
      const docente = await prisma.docente.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (docente !== null) {
        res.json(docente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Docente encontrada',
        //     data: docente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Docente con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Docente',
          error
        }
      );
    }
  },

  async updateDocente(req, res) {
    try {
      const { id } = req.params;
      const { NombreCompleto, Colegiatura, FirmaDigital, UsuarioId } = req.body;
      const docente = await prisma.docente.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { NombreCompleto, Colegiatura, FirmaDigital, UsuarioId }
        }
      );
      res.json(docente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Docente actualizada correctamente',
      //     data: docente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Docente',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Docente
  // async deleteDocente(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.docente.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Docente eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Docente',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = DocenteController;
