const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const IntegranteController = {
  async createIntegrante(req, res) {
    try {
      const { Nombre, ClaseId, EstudianteId } = req.body;
      const integrante = await prisma.integrante.create(
        {
          data: { Nombre, ClaseId, EstudianteId }
        }
      );
      res.json(integrante);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Integrante creada correctamente',
      //     data: integrante
      //   }
      // );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Integrante',
          error: error
        }
      );
    }
  },

  async getAllIntegrantes(req, res) {
    try {
      const integrantes = await prisma.integrante.findMany(
        {
          select: {
            Nombre: true,
            ClaseId: true,
            EstudianteId: true,
            clase: true,
            estudiante: true
          }
        }
      );
      if (integrantes.length > 0) {
        res.json(integrantes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Integrantes',
        //     data: integrantes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Integrantes registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Integrantes',
          error: error
        }
      );
    }
  },

  async claseIntegrante(req, res) {
    try {
      const { codigo } = req.params;
      const integrantes = await prisma.integrante.findMany(
        {
          where: {
            ClaseId: parseInt(codigo)
          },
          select: {
            Nombre: true,
            ClaseId: true,
            EstudianteId: true,
            clase: true,
            estudiante: true
          }
        }
      );
      if (integrantes.length > 0) {
        res.json(integrantes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Integrantes de la Empresa indicada',
        //     data: integrantes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Integrantes registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Integrantes',
          error: error
        }
      );
    }
  },


  async estudianteIntegrante(req, res) {
    try {
      const { codigo } = req.params;
      const integrantes = await prisma.integrante.findMany(
        {
          where: {
            EstudianteId: parseInt(codigo)
          },
          select: {
            Nombre: true,
            ClaseId: true,
            EstudianteId: true,
            clase: true,
            estudiante: true
          }
        }
      );
      if (integrantes.length > 0) {
        res.json(integrantes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Integrantes de la Empresa indicada',
        //     data: integrantes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Integrantes registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Integrantes',
          error: error
        }
      );
    }
  },

  async getIntegranteById(req, res) {
    try {
      const { id } = req.params;
      const integrante = await prisma.integrante.findUnique(
        {
          where: {
            id: parseInt(id)
          },
          select: {
            Nombre: true,
            ClaseId: true,
            EstudianteId: true,
            clase: true,
            estudiante: true
          }
        }
      );
      if (integrante !== null) {
        res.json(integrante);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Integrante encontrada',
        //     data: integrante
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Integrante con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Integrante',
          error: error
        }
      );
    }
  },

  async updateIntegrante(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, ClaseId, EstudianteId } = req.body;
      const integrante = await prisma.integrante.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, ClaseId, EstudianteId }
        }
      );
      res.json(integrante);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Integrante actualizada correctamente',
      //     data: integrante
      //   }
      // );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Integrante',
          error: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Integrante
  // async deleteIntegrante(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.integrante.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Integrante eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Integrante',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = IntegranteController;
