const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const InterpretacionController = {
  async createInterpretacion(req, res) {
    try {
      const { RadiografiaPanoramica, HemogramaCompleto, 
        TiempoSangria, TiempoCoagulacion, 
        FechaRegistro, PacienteId } = req.body;
      const interpretacion = await prisma.interpretacion.create(
        {
          data: { RadiografiaPanoramica, HemogramaCompleto, 
            TiempoSangria, TiempoCoagulacion, 
            FechaRegistro, PacienteId }
        }
      );
      // res.json(interpretacion);
      res.json(
        {
          status: 'success',
          msj: 'Interpretacion creada correctamente',
          data: interpretacion
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Interpretacion',
          error
        }
      );
    }
  },

  async getAllInterpretacions(req, res) {
    try {
      const interpretaciones = await prisma.interpretacion.findMany();
      if (interpretaciones.length > 0) {
        // res.json(interpretaciones);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Interpretacions',
            data: interpretaciones
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Interpretacions registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Interpretacions',
          error
        }
      );
    }
  },

  async getInterpretacionByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const interpretacion = await prisma.interpretacion.findFirst(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (interpretacion !== null) {
        // res.json(interpretacion);
        res.json(
          {
            status: 'success',
            msj: 'Interpretaciones del Paciente',
            data: interpretacion
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Interpretacions registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Interpretacions',
          error
        }
      );
    }
  },

  async getInterpretacionById(req, res) {
    try {
      const { id } = req.params;
      const interpretacion = await prisma.interpretacion.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (interpretacion !== null) {
        // res.json(interpretacion);
        res.json(
          {
            status: 'success',
            msj: 'Interpretacion encontrada',
            data: interpretacion
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Interpretacion con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Interpretacion',
          error
        }
      );
    }
  },

  async updateInterpretacion(req, res) {
    try {
      const { id } = req.params;
      console.log(req.params);
      const { RadiografiaPanoramica, HemogramaCompleto, 
        TiempoSangria, TiempoCoagulacion, 
        FechaRegistro, PacienteId } = req.body;
        console.log(req.body);
      const interpretacion = await prisma.interpretacion.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { RadiografiaPanoramica, HemogramaCompleto, 
            TiempoSangria, TiempoCoagulacion, 
            FechaRegistro, PacienteId }
        }
      );
      // res.json(interpretacion);
      res.json(
        {
          status: 'success',
          msj: 'Interpretacion actualizada correctamente',
          data: interpretacion
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Interpretacion',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Interpretacion
  // async deleteInterpretacion(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.interpretacion.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Interpretacion eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Interpretacion',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = InterpretacionController;
