const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const InterpretacionRadiograficaController = {
  async createInterpretacionRadiografica(req, res) {
    try {
      const { Nombre, Detalle, CirugiaId } = req.body;
      const interpretacionradiografica = await prisma.interpretacionRadiografica.create(
        {
          data: { Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(interpretacionradiografica);
      res.json(
        {
          status: 'success',
          msj: 'InterpretacionRadiografica creada correctamente',
          data: interpretacionradiografica
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la InterpretacionRadiografica',
          error
        }
      );
    }
  },

  async getAllInterpretacionRadiograficas(req, res) {
    try {
      const interpretacionesradiograficas = await prisma.interpretacionRadiografica.findMany();
      if (interpretacionesradiograficas.length > 0) {
        // res.json(interpretacionesradiograficas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de InterpretacionRadiograficas',
            data: interpretacionesradiograficas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay InterpretacionRadiograficas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de InterpretacionRadiograficas',
          error
        }
      );
    }
  },

  async getInterpretacionRadiograficaByCirugia(req, res) {
    try {
      const { codigo } = req.params;
      const interpretacionesradiograficas = await prisma.interpretacionRadiografica.findMany(
        {
          where: {
            CirugiaId: parseInt(codigo)
          }
        }
      );
      if (interpretacionesradiograficas.length > 0) {
        // res.json(interpretacionesradiograficas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de InterpretacionRadiograficas',
            data: interpretacionesradiograficas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay InterpretacionRadiograficas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de InterpretacionRadiograficas',
          error
        }
      );
    }
  },

  async getInterpretacionRadiograficaById(req, res) {
    try {
      const { id } = req.params;
      const interpretacionradiografica = await prisma.interpretacionRadiografica.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (interpretacionradiografica !== null) {
        // res.json(interpretacionradiografica);
        res.json(
          {
            status: 'success',
            msj: 'InterpretacionRadiografica encontrada',
            data: interpretacionradiografica
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la InterpretacionRadiografica con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la InterpretacionRadiografica',
          error
        }
      );
    }
  },

  async updateInterpretacionRadiografica(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Detalle, CirugiaId } = req.body;
      const interpretacionradiografica = await prisma.interpretacionRadiografica.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(interpretacionradiografica);
      res.json(
        {
          status: 'success',
          msj: 'InterpretacionRadiografica actualizada correctamente',
          data: interpretacionradiografica
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la InterpretacionRadiografica',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una InterpretacionRadiografica
  // async deleteInterpretacionRadiografica(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.interpretacionRadiografica.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'InterpretacionRadiografica eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la InterpretacionRadiografica',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = InterpretacionRadiograficaController;
