const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ManifestaciondelDolorController = {
  async createManifestaciondelDolor(req, res) {
    try {
      const { Nombre } = req.body;
      const manifestaciondeldolor = await prisma.manifestaciondelDolor.create(
        {
          data: { Nombre }
        }
      );
      // res.json(manifestaciondeldolor);
      res.json(
        {
          status: 'success',
          msj: 'ManifestaciondelDolor creada correctamente',
          data: manifestaciondeldolor
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la ManifestaciondelDolor',
          error
        }
      );
    }
  },

  async getAllManifestaciondelDolors(req, res) {
    try {
      const manifestacionesdeldolor = await prisma.manifestaciondelDolor.findMany();
      if (manifestacionesdeldolor.length > 0) {
        // res.json(manifestacionesdeldolor);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ManifestaciondelDolors',
            data: manifestacionesdeldolor
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ManifestaciondelDolors registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ManifestaciondelDolors',
          error
        }
      );
    }
  },

  async getManifestaciondelDolorById(req, res) {
    try {
      const { id } = req.params;
      const manifestaciondeldolor = await prisma.manifestaciondelDolor.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (manifestaciondeldolor !== null) {
        // res.json(manifestaciondeldolor);
        res.json(
          {
            status: 'success',
            msj: 'ManifestaciondelDolor encontrada',
            data: manifestaciondeldolor
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ManifestaciondelDolor con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ManifestaciondelDolor',
          error
        }
      );
    }
  },

  async updateManifestaciondelDolor(req, res) {
    try {
      const { id } = req.params;
      const { Nombre } = req.body;
      const manifestaciondeldolor = await prisma.manifestaciondelDolor.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre }
        }
      );
      // res.json(manifestaciondeldolor);
      res.json(
        {
          status: 'success',
          msj: 'ManifestaciondelDolor actualizada correctamente',
          data: manifestaciondeldolor
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ManifestaciondelDolor',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ManifestaciondelDolor
  // async deleteManifestaciondelDolor(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.manifestaciondelDolor.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ManifestaciondelDolor eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ManifestaciondelDolor',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ManifestaciondelDolorController;
