const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ObturaciondeConductosController = {
  async createObturaciondeConductos(req, res) {
    try {
      const { Conducto, Tecnica, UltimaLongitudTrabajo, 
        ConoMaestro, Referencia, FechaRegistro, EndodonciaId } = req.body;
      const obturaciondeconductos = await prisma.obturaciondeConductos.create(
        {
          data: { Conducto, Tecnica, UltimaLongitudTrabajo, 
            ConoMaestro, Referencia, FechaRegistro, EndodonciaId }
        }
      );
      // res.json(obturaciondeconductos);
      res.json(
        {
          status: 'success',
          msj: 'ObturaciondeConductos creada correctamente',
          data: obturaciondeconductos
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la ObturaciondeConductos',
          error
        }
      );
    }
  },

  async getAllObturaciondeConductoss(req, res) {
    try {
      const obturacionesdeconductos = await prisma.obturaciondeConductos.findMany();
      if (obturacionesdeconductos.length > 0) {
        // res.json(obturacionesdeconductos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ObturaciondeConductoss',
            data: obturacionesdeconductos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ObturaciondeConductoss registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ObturaciondeConductoss',
          error
        }
      );
    }
  },

  async getObturaciondeConductosByEndodoncia(req, res) {
    try {
      const { codigo } = req.params;
      const obturacionesdeconductos = await prisma.obturaciondeConductos.findMany(
        {
          where: {
            EndodonciaId: parseInt(codigo)
          }
        }
      );
      if (obturacionesdeconductos.length > 0) {
        // res.json(obturacionesdeconductos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ObturaciondeConductoss',
            data: obturacionesdeconductos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ObturaciondeConductoss registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ObturaciondeConductoss',
          error
        }
      );
    }
  },

  async getObturaciondeConductosById(req, res) {
    try {
      const { id } = req.params;
      const obturaciondeconductos = await prisma.obturaciondeConductos.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (obturaciondeconductos !== null) {
        // res.json(obturaciondeconductos);
        res.json(
          {
            status: 'success',
            msj: 'ObturaciondeConductos encontrada',
            data: obturaciondeconductos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ObturaciondeConductos con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ObturaciondeConductos',
          error
        }
      );
    }
  },

  async updateObturaciondeConductos(req, res) {
    try {
      const { id } = req.params;
      const { Conducto, Tecnica, UltimaLongitudTrabajo, 
        ConoMaestro, Referencia, FechaRegistro, EndodonciaId } = req.body;
      const obturaciondeconductos = await prisma.obturaciondeConductos.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Conducto, Tecnica, UltimaLongitudTrabajo, 
            ConoMaestro, Referencia, FechaRegistro, EndodonciaId }
        }
      );
      // res.json(obturaciondeconductos);
      res.json(
        {
          status: 'success',
          msj: 'ObturaciondeConductos actualizada correctamente',
          data: obturaciondeconductos
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ObturaciondeConductos',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ObturaciondeConductos
  // async deleteObturaciondeConductos(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.obturaciondeConductos.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ObturaciondeConductos eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ObturaciondeConductos',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ObturaciondeConductosController;
