const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PlandeTrabajoController = {
  async createPlandeTrabajo(req, res) {
    try {
      const { Cantidad, TratamientoRestauracionconMaterialAdhesivo, PiezaNumero, 
        TipodeMaterialRestaurador, FechaRegistro, OperatoriaId } = req.body;
      const plandetrabajo = await prisma.plandeTrabajo.create(
        {
          data: { Cantidad, TratamientoRestauracionconMaterialAdhesivo, PiezaNumero, 
            TipodeMaterialRestaurador, FechaRegistro, OperatoriaId }
        }
      );
      // res.json(plandetrabajo);
      res.json(
        {
          status: 'success',
          msj: 'PlandeTrabajo creada correctamente',
          data: plandetrabajo
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la PlandeTrabajo',
          error
        }
      );
    }
  },

  async getAllPlandeTrabajos(req, res) {
    try {
      const planesdetrabajo = await prisma.plandeTrabajo.findMany();
      if (planesdetrabajo.length > 0) {
        // res.json(planesdetrabajo);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PlandeTrabajos',
            data: planesdetrabajo
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PlandeTrabajos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PlandeTrabajos',
          error
        }
      );
    }
  },

  async getPlandeTrabajoByOperatoria(req, res) {
    try {
      const { codigo } = req.params;
      const planesdetrabajo = await prisma.plandeTrabajo.findMany(
        {
          where: {
            OperatoriaId: parseInt(codigo)
          }
        }
      );
      if (planesdetrabajo.length > 0) {
        // res.json(planesdetrabajo);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PlandeTrabajos',
            data: planesdetrabajo
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PlandeTrabajos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PlandeTrabajos',
          error
        }
      );
    }
  },

  async getPlandeTrabajoById(req, res) {
    try {
      const { id } = req.params;
      const plandetrabajo = await prisma.plandeTrabajo.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (plandetrabajo !== null) {
        // res.json(plandetrabajo);
        res.json(
          {
            status: 'success',
            msj: 'PlandeTrabajo encontrada',
            data: plandetrabajo
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la PlandeTrabajo con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la PlandeTrabajo',
          error
        }
      );
    }
  },

  async updatePlandeTrabajo(req, res) {
    try {
      const { id } = req.params;
      const { Cantidad, TratamientoRestauracionconMaterialAdhesivo, PiezaNumero, 
        TipodeMaterialRestaurador, FechaRegistro, OperatoriaId } = req.body;
      const plandetrabajo = await prisma.plandeTrabajo.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Cantidad, TratamientoRestauracionconMaterialAdhesivo, PiezaNumero, 
            TipodeMaterialRestaurador, FechaRegistro, OperatoriaId }
        }
      );
      // res.json(plandetrabajo);
      res.json(
        {
          status: 'success',
          msj: 'PlandeTrabajo actualizada correctamente',
          data: plandetrabajo
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la PlandeTrabajo',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una PlandeTrabajo
  // async deletePlandeTrabajo(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.plandeTrabajo.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'PlandeTrabajo eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la PlandeTrabajo',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PlandeTrabajoController;
