const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PreparacionQuimicoMecanicaController = {
  async createPreparacionQuimicoMecanica(req, res) {
    try {
      const { Conducto, Tecnica, IFinal, 
        UltimaLongitudTrabajo, Referencia, 
        FechaRegistro, EndodonciaId } = req.body;
      const preparacionquimicomecanica = await prisma.preparacionQuimicoMecanica.create(
        {
          data: { Conducto, Tecnica, IFinal, 
            UltimaLongitudTrabajo, Referencia, 
            FechaRegistro, EndodonciaId }
        }
      );
      // res.json(preparacionquimicomecanica);
      res.json(
        {
          status: 'success',
          msj: 'PreparacionQuimicoMecanica creada correctamente',
          data: preparacionquimicomecanica
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la PreparacionQuimicoMecanica',
          error
        }
      );
    }
  },

  async getAllPreparacionQuimicoMecanicas(req, res) {
    try {
      const preparacionesquimicomecanica = await prisma.preparacionQuimicoMecanica.findMany();
      if (preparacionesquimicomecanica.length > 0) {
        // res.json(preparacionesquimicomecanica);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PreparacionQuimicoMecanicas',
            data: preparacionesquimicomecanica
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PreparacionQuimicoMecanicas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PreparacionQuimicoMecanicas',
          error
        }
      );
    }
  },

  async getPreparacionQuimicoMecanicaByEndodoncia(req, res) {
    try {
      const { codigo } = req.params;
      const preparacionesquimicomecanica = await prisma.preparacionQuimicoMecanica.findMany(
        {
          where: {
            EndodonciaId: parseInt(codigo)
          }
        }
      );
      if (preparacionesquimicomecanica.length > 0) {
        // res.json(preparacionesquimicomecanica);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PreparacionQuimicoMecanicas',
            data: preparacionesquimicomecanica
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PreparacionQuimicoMecanicas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PreparacionQuimicoMecanicas',
          error
        }
      );
    }
  },

  async getPreparacionQuimicoMecanicaById(req, res) {
    try {
      const { id } = req.params;
      const preparacionquimicomecanica = await prisma.preparacionQuimicoMecanica.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (preparacionquimicomecanica !== null) {
        // res.json(preparacionquimicomecanica);
        res.json(
          {
            status: 'success',
            msj: 'PreparacionQuimicoMecanica encontrada',
            data: preparacionquimicomecanica
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la PreparacionQuimicoMecanica con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la PreparacionQuimicoMecanica',
          error
        }
      );
    }
  },

  async updatePreparacionQuimicoMecanica(req, res) {
    try {
      const { id } = req.params;
      const { Conducto, Tecnica, IFinal, 
        UltimaLongitudTrabajo, Referencia, 
        FechaRegistro, EndodonciaId } = req.body;
      const preparacionquimicomecanica = await prisma.preparacionQuimicoMecanica.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Conducto, Tecnica, IFinal, 
            UltimaLongitudTrabajo, Referencia, 
            FechaRegistro, EndodonciaId }
        }
      );
      // res.json(preparacionquimicomecanica);
      res.json(
        {
          status: 'success',
          msj: 'PreparacionQuimicoMecanica actualizada correctamente',
          data: preparacionquimicomecanica
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la PreparacionQuimicoMecanica',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una PreparacionQuimicoMecanica
  // async deletePreparacionQuimicoMecanica(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.preparacionQuimicoMecanica.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         mesj: 'PreparacionQuimicoMecanica eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la PreparacionQuimicoMecanica',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PreparacionQuimicoMecanicaController;
