const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PruebaController = {
  async createPrueba(req, res) {
    try {
      const { Nombre } = req.body;
      const prueba = await prisma.prueba.create(
        {
          data: { Nombre }
        }
      );
      // res.json(prueba);
      res.json(
        {
          status: 'success',
          msj: 'Prueba creada correctamente',
          data: prueba
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Prueba',
          error
        }
      );
    }
  },

  async getAllPruebas(req, res) {
    try {
      const pruebas = await prisma.prueba.findMany();
      if (pruebas.length > 0) {
        // res.json(pruebas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Pruebas',
            data: pruebas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Pruebas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Pruebas',
          error
        }
      );
    }
  },

  async getPruebaById(req, res) {
    try {
      const { id } = req.params;
      const prueba = await prisma.prueba.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (prueba !== null) {
        // res.json(prueba);
        res.json(
          {
            status: 'success',
            msj: 'Prueba encontrada',
            data: prueba
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Prueba con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Prueba',
          error
        }
      );
    }
  },

  async updatePrueba(req, res) {
    try {
      const { id } = req.params;
      const { Nombre } = req.body;
      const prueba = await prisma.prueba.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre }
        }
      );
      // res.json(prueba);
      res.json(
        {
          status: 'success',
          msj: 'Prueba actualizada correctamente',
          data: prueba
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Prueba',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Prueba
  // async deletePrueba(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.prueba.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Prueba eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Prueba',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PruebaController;
