const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const RadiografiaCirugiaController = {
  async createRadiografiaCirugia(req, res) {
    try {
      const { Fecha, Nombre, Foto, Interpretacion, FechaRegistro, CirugiaId } = req.body;
      const radiografiacirugia = await prisma.radiografiaCirugia.create(
        {
          data: { Fecha, Nombre, Foto, Interpretacion, FechaRegistro, CirugiaId }
        }
      );
      // res.json(radiografiacirugia);
      res.json(
        {
          status: 'success',
          msj: 'RadiografiaCirugia creada correctamente',
          data: radiografiacirugia
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la RadiografiaCirugia',
          error
        }
      );
    }
  },

  async getAllRadiografiaCirugias(req, res) {
    try {
      const radiografiascirugia = await prisma.radiografiaCirugia.findMany();
      if (radiografiascirugia.length > 0) {
        // res.json(radiografiascirugia);
        res.json(
          {
            status: 'success',
            msj: 'Lista de RadiografiaCirugias',
            data: radiografiascirugia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay RadiografiaCirugias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de RadiografiaCirugias',
          error
        }
      );
    }
  },

  async getRadiografiaCirugiaByCirugia(req, res) {
    try {
      const { codigo } = req.params;
      const radiografiascirugia = await prisma.radiografiaCirugia.findMany(
        {
          where: {
            CirugiaId: parseInt(codigo)
          }
        }
      );
      if (radiografiascirugia.length > 0) {
        // res.json(radiografiascirugia);
        res.json(
          {
            status: 'success',
            msj: 'Lista de RadiografiaCirugias',
            data: radiografiascirugia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay RadiografiaCirugias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de RadiografiaCirugias',
          error
        }
      );
    }
  },

  async getRadiografiaCirugiaById(req, res) {
    try {
      const { id } = req.params;
      const radiografiacirugia = await prisma.radiografiaCirugia.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (radiografiacirugia !== null) {
        // res.json(radiografiacirugia);
        res.json(
          {
            status: 'success',
            msj: 'RadiografiaCirugia encontrada',
            data: radiografiacirugia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la RadiografiaCirugia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la RadiografiaCirugia',
          error
        }
      );
    }
  },

  async updateRadiografiaCirugia(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Nombre, Foto, Interpretacion, FechaRegistro, CirugiaId } = req.body;
      const radiografiacirugia = await prisma.radiografiaCirugia.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Nombre, Foto, Interpretacion, FechaRegistro, CirugiaId }
        }
      );
      // res.json(radiografiacirugia);
      res.json(
        {
          status: 'success',
          msj: 'RadiografiaCirugia actualizada correctamente',
          data: radiografiacirugia
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la RadiografiaCirugia',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una RadiografiaCirugia
  // async deleteRadiografiaCirugia(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.radiografiaCirugia.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'RadiografiaCirugia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la RadiografiaCirugia',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = RadiografiaCirugiaController;
