const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const RadiografiaEndodonciaController = {
  async createRadiografiaEndodoncia(req, res) {
    try {
      const { Fecha, Foto, Interpretacion, FechaRegistro, EndodonciaId } = req.body;
      const radiografiaendodoncia = await prisma.radiografiaEndodoncia.create(
        {
          data: { Fecha, Foto, Interpretacion, FechaRegistro, EndodonciaId }
        }
      );
      // res.json(radiografiaendodoncia);
      res.json(
        {
          status: 'success',
          msj: 'RadiografiaEndodoncia creada correctamente',
          data: radiografiaendodoncia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la RadiografiaEndodoncia',
          error
        }
      );
    }
  },

  async getAllRadiografiaEndodoncias(req, res) {
    try {
      const radiografiasendodoncia = await prisma.radiografiaEndodoncia.findMany();
      if (radiografiasendodoncia.length > 0) {
        // res.json(radiografiasendodoncia);
        res.json(
          {
            status: 'success',
            msj: 'Lista de RadiografiaEndodoncias',
            data: radiografiasendodoncia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay RadiografiaEndodoncias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de RadiografiaEndodoncias',
          error
        }
      );
    }
  },

  async getRadiografiaEndodonciaByEndodoncia(req, res) {
    try {
      const { codigo } = req.params;
      const radiografiasendodoncia = await prisma.radiografiaEndodoncia.findMany(
        {
          where: {
            EndodonciaId: parseInt(codigo)
          }
        }
      );
      if (radiografiasendodoncia.length > 0) {
        // res.json(radiografiasendodoncia);
        res.json(
          {
            status: 'success',
            msj: 'Lista de RadiografiaEndodoncias',
            data: radiografiasendodoncia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay RadiografiaEndodoncias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de RadiografiaEndodoncias',
          error
        }
      );
    }
  },

  async getRadiografiaEndodonciaById(req, res) {
    try {
      const { id } = req.params;
      const radiografiaendodoncia = await prisma.radiografiaEndodoncia.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (radiografiaendodoncia !== null) {
        // res.json(radiografiaendodoncia);
        res.json(
          {
            status: 'success',
            msj: 'RadiografiaEndodoncia encontrada',
            data: radiografiaendodoncia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la RadiografiaEndodoncia con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la RadiografiaEndodoncia',
          error
        }
      );
    }
  },

  async updateRadiografiaEndodoncia(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Foto, Interpretacion, FechaRegistro, EndodonciaId } = req.body;
      const radiografiaendodoncia = await prisma.radiografiaEndodoncia.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Foto, Interpretacion, FechaRegistro, EndodonciaId }
        }
      );
      // res.json(radiografiaendodoncia);
      res.json(
        {
          status: 'success',
          msj: 'RadiografiaEndodoncia actualizada correctamente',
          data: radiografiaendodoncia
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la RadiografiaEndodoncia',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una RadiografiaEndodoncia
  // async deleteRadiografiaEndodoncia(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.radiografiaEndodoncia.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'RadiografiaEndodoncia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la RadiografiaEndodoncia',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = RadiografiaEndodonciaController;
