const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const TecnicaRadiograficaController = {
  async createTecnicaRadiografica(req, res) {
    try {
      const { NumeroPieza, Detalle, Tipo, OperatoriaId } = req.body;
      const tecnicaradiografica = await prisma.tecnicaRadiografica.create(
        {
          data: { NumeroPieza, Detalle, Tipo, OperatoriaId }
        }
      );
      // res.json(tecnicaradiografica);
      res.json(
        {
          status: 'success',
          msj: 'TecnicaRadiografica creada correctamente',
          data: tecnicaradiografica
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la TecnicaRadiografica',
          error
        }
      );
    }
  },

  async getAllTecnicaRadiograficas(req, res) {
    try {
      const tecnicasradiograficas = await prisma.tecnicaRadiografica.findMany();
      if (tecnicasradiograficas.length > 0) {
        // res.json(tecnicasradiograficas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de TecnicaRadiograficas',
            data: tecnicasradiograficas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay TecnicaRadiograficas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de TecnicaRadiograficas',
          error
        }
      );
    }
  },

  async getTecnicaRadiograficaByOperatoria(req, res) {
    try {
      const { codigo } = req.params;
      const tecnicasradiograficas = await prisma.tecnicaRadiografica.findMany(
        {
          where: {
            OperatoriaId: parseInt(codigo)
          }
        }
      );
      if (tecnicasradiograficas.length > 0) {
        // res.json(tecnicasradiograficas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de TecnicaRadiograficas',
            data: tecnicasradiograficas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay TecnicaRadiograficas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de TecnicaRadiograficas',
          error
        }
      );
    }
  },

  async getTecnicaRadiograficaById(req, res) {
    try {
      const { id } = req.params;
      const tecnicaradiografica = await prisma.tecnicaRadiografica.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (tecnicaradiografica !== null) {
        // res.json(tecnicaradiografica);
        res.json(
          {
            status: 'success',
            msj: 'TecnicaRadiografica encontrada',
            data: tecnicaradiografica
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la TecnicaRadiografica con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la TecnicaRadiografica',
          error
        }
      );
    }
  },

  async updateTecnicaRadiografica(req, res) {
    try {
      const { id } = req.params;
      const { NumeroPieza, Detalle, Tipo, OperatoriaId } = req.body;
      const tecnicaradiografica = await prisma.tecnicaRadiografica.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { NumeroPieza, Detalle, Tipo, OperatoriaId }
        }
      );
      // res.json(tecnicaradiografica);
      res.json(
        {
          status: 'success',
          msj: 'TecnicaRadiografica actualizada correctamente',
          data: tecnicaradiografica
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la TecnicaRadiografica',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una TecnicaRadiografica
  // async deleteTecnicaRadiografica(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.tecnicaRadiografica.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'TecnicaRadiografica eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la TecnicaRadiografica',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = TecnicaRadiograficaController;
