const { PrismaClient } = require('@prisma/client');
const bcrypt = require('bcryptjs');

const prisma = new PrismaClient();

const UsuarioController = {
  async createUsuario(req, res) {
    try {
      const { 
        Nombre, Apellido, Celular, Correo, NumDoc, Contra, 
        Foto, Pago, Codigo, Activo, Genero, Estado, Rol, TipoDocumento, 
        RestablecerContra, SedeId } = req.body;
      const hashedPassword = await bcrypt.hash(Contra, 15);
      const usuario = await prisma.usuario.create(
        {
          data: {
            Nombre, Apellido, Celular, Correo, NumDoc, Contra: hashedPassword,
            Foto, Pago, Codigo, Activo, Genero, Estado, Rol, TipoDocumento, RestablecerContra, SedeId
          }
        }
      );
      res.json(usuario);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Usuario creada correctamente',
      //     data: usuario
      //   }
      // );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Usuario',
          err: error
        }
      );
    }
  },

  async getAllUsuarios(req, res) {
    try {
      const usuarios = await prisma.usuario.findMany();
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async sedeUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const usuarios = await prisma.usuario.findMany(
        {
          where: {
            SedeId: parseInt(codigo)
          }
        }
      );
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios de la Sede indicada',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async rolUsuario(req, res) {
    try {
      const { elrol } = req.params;
      const usuarios = await prisma.usuario.findMany(
        {
          where: {
            Rol: elrol
          }
        }
      );
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios de la Sede indicada',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async condicionUsuario(req, res) {
    try {
      const { lacondicion } = req.params;
      const usuarios = await prisma.usuario.findMany(
        {
          where: {
            Activo: lacondicion
          }
        }
      );
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios de la Sede indicada',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async docenteUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const usuarios = await prisma.usuario.findMany(
        {
          where: {
            SedeId: parseInt(codigo),
            Rol: 'docente'
          }
        }
      );
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios de la Sede indicada',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async estudianteUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const usuarios = await prisma.usuario.findMany(
        {
          where: {
            SedeId: parseInt(codigo),
            Rol: 'estudiante'
          }
        }
      );
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios de la Sede indicada',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async administradorUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const usuarios = await prisma.usuario.findMany(
        {
          where: {
            SedeId: parseInt(codigo),
            Rol: 'administrador'
          }
        }
      );
      if (usuarios.length > 0) {
        res.json(usuarios);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Usuarios de la Sede indicada',
        //     data: usuarios
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Usuarios registradas de la Sede indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Usuarios',
          error
        }
      );
    }
  },

  async getUsuarioById(req, res) {
    try {
      const { id } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (usuario !== null) {
        res.json(usuario);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Usuario encontrada',
        //     data: usuario
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioByCorreo(req, res) {
    try {
      const { elcorreo } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            Correo: elcorreo
          }
        }
      );
      if (usuario !== null) {
        res.json(usuario);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Usuario encontrada',
        //     data: usuario
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioByCelular(req, res) {
    try {
      const { elcelular } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            Celular: elcelular
          }
        }
      );
      if (usuario !== null) {
        res.json(usuario);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Usuario encontrada',
        //     data: usuario
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioByDoc(req, res) {
    try {
      const { eldocumento } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            NumDoc: eldocumento
          }
        }
      );
      if (usuario !== null) {
        res.json(usuario);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Usuario encontrada',
        //     data: usuario
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioEstudianteByCelular(req, res) {
    try {
      const { elcelular, lasede } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            Celular: elcelular,
            SedeId: parseInt(lasede),
            Rol: 'estudiante'

          }
        }
      );
      if (usuario !== null) {
        res.json(usuario);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Usuario encontrada',
        //     data: usuario
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioEstudianteByDoc(req, res) {
    try {
      const { eldocumento, lasede } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            NumDoc: eldocumento,
            SedeId: parseInt(lasede),
            Rol: 'estudiante'

          }
        }
      );
      if (usuario !== null) {
        res.json(usuario);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Usuario encontrada',
        //     data: usuario
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioByLoginEmail(req, res) {
    try {
      const { correo, contra } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            Correo: correo
          }
        }
      );
      if (usuario !== null) {
        const parametro = bcrypt.compareSync(contra, usuario.Contra);
        console.log(parametro,contra, usuario.Contra);
        if (parametro) {
          // res.json(usuario);
          res.json(
            {
              status: 'success',
              msj: 'Usuario encontrada',
              data: usuario
            }
          );
        } else {
          res.json(
            {
              status: 'warning',
              msj: 'El Correo es Correcto; pero la Contra es incorrecta'
            }
          );
        }
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe un Usuario con el correo proporcionado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioByLoginPhone(req, res) {
    try {
      const { celular, contra } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            Celular: celular
          }
        }
      );
      if (usuario !== null) {
        const parametro = bcrypt.compareSync(contra, usuario.Contra);
        if (parametro) {
          // res.json(usuario);
          res.json(
            {
              status: 'success',
              msj: 'Usuario encontrada',
              data: usuario
            }
          );
        } else {
          res.json(
            {
              status: 'warning',
              msj: 'El Celuar es Correcto; pero la Contra es incorrecta'
            }
          );
        }
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el Celular proporsionado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async getUsuarioByRecover(req, res) {
    try {
      const { codigo, id } = req.params;
      const usuario = await prisma.usuario.findUnique(
        {
          where: {
            Codigo: codigo,
            RestablecerContra: 'activado',
            id: id
          }
        }
      );
      if (usuario !== null) {
        // res.json(usuario);
        res.json(
          {
            status: 'success',
            msj: 'Usuario encontrada',
            data: usuario
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Usuario con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Usuario',
          error
        }
      );
    }
  },

  async updateUsuario(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Apellido, Celular, Correo, NumDoc, Contra, Foto, Pago, Codigo, 
        Activo, Genero, Estado, Rol, TipoDocumento, RestablecerContra, SedeId } = req.body;
      const usuario = await prisma.usuario.update(
        {
          where: {
            id: parseInt(id)
          },
          data: {
            Nombre, Apellido, Celular, Correo, NumDoc, Contra,
            Foto, Pago, Codigo, Activo, Genero, Estado, Rol, TipoDocumento, 
            RestablecerContra, SedeId
          }
        }
      );
      res.json(usuario);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Usuario actualizada correctamente',
      //     data: usuario
      //   }
      // );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Usuario',
          error
        }
      );
    }
  },

  async updateUsuarioContra(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Apellido, Celular, Correo, NumDoc, Contra, Foto, Pago, Codigo, 
        Activo, Genero, Estado, Rol, TipoDocumento, RestablecerContra, SedeId } = req.body;
      const hashedPassword = await bcrypt.hash(Contra, 15);
      console.log(hashedPassword);
      const eldato = await prisma.usuario.update(
        {
          where: {
            id: parseInt(id)
          },
          data: {
            Nombre, Apellido, Celular, Correo, NumDoc, Contra: hashedPassword,
            Foto, Pago, Codigo, Activo, Genero, Estado, Rol, TipoDocumento, 
            RestablecerContra, SedeId
          }
        }
      );
      // res.json(eldato);
      res.json(
        {
          status: 'success',
          msj: 'Contraseña actualizada correctamente',
          data: eldato
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Contraseña',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Usuario
  // async deleteUsuario(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.usuario.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         msj: 'Usuario eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Usuario',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = UsuarioController;




