-- CreateTable
CREATE TABLE "Empresa" (
    "id" SERIAL NOT NULL,
    "Ruc" TEXT NOT NULL,
    "RazonSocial" TEXT NOT NULL,
    "Representante" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Empresa_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Diagnostico" (
    "id" SERIAL NOT NULL,
    "Tipo" TEXT NOT NULL,
    "Codigo" TEXT NOT NULL,
    "Resumen" TEXT NOT NULL,
    "Descripcion" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Diagnostico_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Sede" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Direccion" TEXT NOT NULL,
    "Celular" TEXT NOT NULL,
    "Correo" TEXT NOT NULL,
    "TipoSede" TEXT NOT NULL,
    "EmpresaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Sede_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Curso" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Semestre" TEXT NOT NULL,
    "Malla" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Curso_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Periodo" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Empieza" TIMESTAMP(3) NOT NULL,
    "Termina" TIMESTAMP(3) NOT NULL,
    "SedeId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Periodo_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Usuario" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Apellido" TEXT NOT NULL,
    "Celular" TEXT NOT NULL,
    "Correo" TEXT NOT NULL,
    "NumDoc" TEXT NOT NULL,
    "Contra" TEXT NOT NULL,
    "Foto" TEXT NOT NULL,
    "Pago" TEXT NOT NULL,
    "Codigo" TEXT NOT NULL,
    "Activo" BOOLEAN NOT NULL DEFAULT false,
    "Genero" TEXT NOT NULL,
    "TipoDocumento" TEXT NOT NULL,
    "RestablecerContra" TEXT NOT NULL,
    "Rol" TEXT NOT NULL,
    "SedeId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Usuario_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Auditoria" (
    "id" SERIAL NOT NULL,
    "Registroid" INTEGER NOT NULL,
    "Accion" TEXT NOT NULL,
    "Tabla" TEXT NOT NULL,
    "Resumen" TEXT NOT NULL,
    "Detalle" TEXT NOT NULL,
    "Interaccion" TIMESTAMP(3) NOT NULL,
    "UsuarioId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Auditoria_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Administrador" (
    "id" SERIAL NOT NULL,
    "NombreCompleto" TEXT NOT NULL,
    "CodigoAcceso" TEXT NOT NULL,
    "UsuarioId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Administrador_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Docente" (
    "id" SERIAL NOT NULL,
    "NombreCompleto" TEXT NOT NULL,
    "Colegiatura" TEXT NOT NULL,
    "FirmaDigital" TEXT NOT NULL,
    "UsuarioId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Docente_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Estudiante" (
    "id" SERIAL NOT NULL,
    "NombreCompleto" TEXT NOT NULL,
    "Semestre" TEXT NOT NULL,
    "Firma" TEXT NOT NULL,
    "UsuarioId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Estudiante_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Clase" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Salon" TEXT NOT NULL,
    "Horario" TEXT NOT NULL,
    "idDocente" INTEGER NOT NULL,
    "idPeriodo" INTEGER NOT NULL,
    "idCurso" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Clase_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Integrante" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "ClaseId" INTEGER NOT NULL,
    "EstudianteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Integrante_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Diente" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Ubicacion" TEXT NOT NULL,
    "Tipo" TEXT NOT NULL,
    "Lado" TEXT NOT NULL,
    "Posicion" TEXT NOT NULL,
    "Raiz" TEXT NOT NULL,
    "Estado" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Diente_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "CasoClinico" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "CasoClinico_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "SubCasoClinico" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "CasoClinicoId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "SubCasoClinico_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "CasoDiente" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Foto" TEXT NOT NULL,
    "SubCasoClinicoId" INTEGER NOT NULL,
    "DienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "CasoDiente_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Paciente" (
    "id" SERIAL NOT NULL,
    "FechaCreacion" TIMESTAMP(3) NOT NULL,
    "HoraCreacion" TIMESTAMP(3) NOT NULL,
    "NumeroHistoriaClinica" TEXT NOT NULL,
    "Ectoscopia" TEXT NOT NULL,
    "Nombre" TEXT NOT NULL,
    "ApellidoPaterno" TEXT NOT NULL,
    "ApellidoMaterno" TEXT NOT NULL,
    "Sexo" TEXT NOT NULL,
    "Lugar" TEXT NOT NULL,
    "Domicilio" TEXT NOT NULL,
    "FechaNacimiento" TIMESTAMP(3) NOT NULL,
    "EstadoCivil" TEXT NOT NULL,
    "NroCelular" TEXT NOT NULL,
    "Correo" TEXT NOT NULL,
    "Raza" TEXT NOT NULL,
    "GradoInstruccion" TEXT NOT NULL,
    "Ocupacion" TEXT NOT NULL,
    "Responsable" TEXT NOT NULL,
    "ParentescoconResponsable" TEXT NOT NULL,
    "DomicilioResponsable" TEXT NOT NULL,
    "CelularResponsable" TEXT NOT NULL,
    "Acompaniante" TEXT NOT NULL,
    "EnfermedadActual" TEXT NOT NULL,
    "MotivoConsulta" TEXT NOT NULL,
    "FuncionesBiologicas" TEXT NOT NULL,
    "Orina" TEXT NOT NULL,
    "Apetito" TEXT NOT NULL,
    "Suenio" TEXT NOT NULL,
    "Deposiciones" TEXT NOT NULL,
    "Sed" TEXT NOT NULL,
    "Alergias" TEXT NOT NULL,
    "AntecedentesAlergicos" TEXT NOT NULL,
    "AntecedentesPersonal" TEXT NOT NULL,
    "AntecedentesFamiliar" TEXT NOT NULL,
    "AntecedentesPatologicos" TEXT NOT NULL,
    "SedeId" INTEGER NOT NULL,
    "UsuarioId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Paciente_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Cita" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Hora" TEXT NOT NULL,
    "Odontologo" TEXT NOT NULL,
    "Empresa" TEXT NOT NULL,
    "Sede" TEXT NOT NULL,
    "Lugar" TEXT NOT NULL,
    "Extras" TEXT NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "UsuarioId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Cita_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Odontograma" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Estado" TEXT NOT NULL,
    "Numero" TEXT NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Odontograma_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Mapeo" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "OdontogramaId" INTEGER NOT NULL,
    "CasodienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Mapeo_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "CarasDiente" (
    "id" SERIAL NOT NULL,
    "Mesial" TEXT NOT NULL,
    "Distal" TEXT NOT NULL,
    "Vestibular" TEXT NOT NULL,
    "Lingual" TEXT NOT NULL,
    "Palatina" TEXT NOT NULL,
    "MapeoId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "CarasDiente_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ExamenGeneral" (
    "id" SERIAL NOT NULL,
    "Peso" TEXT NOT NULL,
    "Talla" TEXT NOT NULL,
    "IndiceMasaCorporal" TEXT NOT NULL,
    "Piel" TEXT NOT NULL,
    "AnexoCabello" TEXT NOT NULL,
    "AnexoUnias" TEXT NOT NULL,
    "PresionArterial" TEXT NOT NULL,
    "FrecuenciaRespiratoria" TEXT NOT NULL,
    "Pulso" TEXT NOT NULL,
    "Temperatura" TEXT NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ExamenGeneral_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Anamnesis" (
    "id" SERIAL NOT NULL,
    "Contenido" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Anamnesis_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "DiagnosticoPresuntivo" (
    "id" SERIAL NOT NULL,
    "Diagnostico" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "DiagnosticoPresuntivo_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ExamenesAuxiliares" (
    "id" SERIAL NOT NULL,
    "Contenido" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ExamenesAuxiliares_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "DiagnosticoDefinitivo" (
    "id" SERIAL NOT NULL,
    "Diagnostico" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "DiagnosticoDefinitivo_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Epicrisis" (
    "id" SERIAL NOT NULL,
    "Contenido" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Epicrisis_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Interpretacion" (
    "id" SERIAL NOT NULL,
    "RadiografiaPanoramica" TEXT NOT NULL,
    "HemogramaCompleto" TEXT NOT NULL,
    "TiempoSangria" TEXT NOT NULL,
    "TiempoCoagulacion" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Interpretacion_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "NotaEvolutiva" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Tratamiento" TEXT NOT NULL,
    "Firma" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "NotaEvolutiva_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "PlanyCronogramaCompleto" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Resumen" TEXT NOT NULL,
    "Especificaciones" TEXT NOT NULL,
    "Observaciones" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "PlanyCronogramaCompleto_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ExamenEstomatologico" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Facie" TEXT NOT NULL,
    "Craneo" TEXT NOT NULL,
    "Cara" TEXT NOT NULL,
    "SimetriaTresTercios" TEXT NOT NULL,
    "SimetriaBilateral" TEXT NOT NULL,
    "SimetriaPerfil" TEXT NOT NULL,
    "ATMTrayectoriaAperturayCierre" TEXT NOT NULL,
    "ATMfluidosdelaATM" TEXT NOT NULL,
    "ATMpalpitacion" TEXT NOT NULL,
    "ATMGradodeApertura" TEXT NOT NULL,
    "Ganglios" TEXT NOT NULL,
    "EnciaNormal" TEXT NOT NULL,
    "EnciaFaltaoAusencia" TEXT NOT NULL,
    "EnciaIncosistencia" TEXT NOT NULL,
    "ColorNormal" TEXT NOT NULL,
    "ColorEritematosa" TEXT NOT NULL,
    "ColorPalida" TEXT NOT NULL,
    "TexturaNormal" TEXT NOT NULL,
    "TexturaLisa" TEXT NOT NULL,
    "TexturaRugosa" TEXT NOT NULL,
    "ConsistenciaNormal" TEXT NOT NULL,
    "ConsistenciaEdematosa" TEXT NOT NULL,
    "ConsistenciaFibrosa" TEXT NOT NULL,
    "EnciaPapilarNormal" TEXT NOT NULL,
    "EnciaPapilarAplanada" TEXT NOT NULL,
    "EnciaPapilarCrateriforme" TEXT NOT NULL,
    "Encia" TEXT NOT NULL,
    "MaxilarSuperior" TEXT NOT NULL,
    "MaxilarInferior" TEXT NOT NULL,
    "Numero" TEXT NOT NULL,
    "Color" TEXT NOT NULL,
    "Forma" TEXT NOT NULL,
    "Tamanio" TEXT NOT NULL,
    "Diastemas" TEXT NOT NULL,
    "ZonasEdentulasyRebordeAlveolar" TEXT NOT NULL,
    "AlteraciondePosiciones" TEXT NOT NULL,
    "FacetadeDesgaste" TEXT NOT NULL,
    "LineaMedia" TEXT NOT NULL,
    "Otro" TEXT NOT NULL,
    "LabiosyComisuraLabial" TEXT NOT NULL,
    "PaladarDuroyBlando" TEXT NOT NULL,
    "Carrillos" TEXT NOT NULL,
    "PisodeBoca" TEXT NOT NULL,
    "Lengua" TEXT NOT NULL,
    "Orofaringe" TEXT NOT NULL,
    "Frenillos" TEXT NOT NULL,
    "Saliva" TEXT NOT NULL,
    "Temporal" TEXT NOT NULL,
    "Masetero" TEXT NOT NULL,
    "PteriogoideoInterno" TEXT NOT NULL,
    "PteriogoideoExterno" TEXT NOT NULL,
    "Digastrico" TEXT NOT NULL,
    "Esternocleidomastoideo" TEXT NOT NULL,
    "RelacionMolarDerecha" TEXT NOT NULL,
    "RelacionMolarIzquierda" TEXT NOT NULL,
    "RelacionCanicaDerecha" TEXT NOT NULL,
    "RelacionCanicaIzquierda" TEXT NOT NULL,
    "GradoApertura" TEXT NOT NULL,
    "OverBite" TEXT NOT NULL,
    "OverJet" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ExamenEstomatologico_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Endodoncia" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Docente" TEXT NOT NULL,
    "Observaciones" TEXT NOT NULL,
    "Operador" TEXT NOT NULL,
    "MotivoConsulta" TEXT NOT NULL,
    "PiezaDental" TEXT NOT NULL,
    "ECPercucion" TEXT NOT NULL,
    "ECCavidad" TEXT NOT NULL,
    "ECCambiodeColor" TEXT NOT NULL,
    "ECTejidosBlandos" TEXT NOT NULL,
    "ECTermoreaccion" TEXT NOT NULL,
    "ECElectroReaccion" TEXT NOT NULL,
    "ERCavidad" TEXT NOT NULL,
    "ERTratamientoPrevio" TEXT NOT NULL,
    "ERPeriodonto" TEXT NOT NULL,
    "ERLesionesPeriauriculares" TEXT NOT NULL,
    "ERNumerodeConductos" TEXT NOT NULL,
    "ERPrecipitacionesCalcicas" TEXT NOT NULL,
    "STAnestesia" TEXT NOT NULL,
    "STAAislamientoAbsoluto" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Endodoncia_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ManifestaciondelDolor" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ManifestaciondelDolor_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ManifestacionEndodoncia" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "EndodonciaId" INTEGER NOT NULL,
    "ManifestaciondelDolorId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ManifestacionEndodoncia_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Conductometria" (
    "id" SERIAL NOT NULL,
    "Conducto" TEXT NOT NULL,
    "LongRx" TEXT NOT NULL,
    "LongTrabajo" TEXT NOT NULL,
    "IInicial" TEXT NOT NULL,
    "Referencia" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "EndodonciaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Conductometria_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "PreparacionQuimicoMecanica" (
    "id" SERIAL NOT NULL,
    "Conducto" TEXT NOT NULL,
    "Tecnica" TEXT NOT NULL,
    "IFinal" TEXT NOT NULL,
    "UltimaLongitudTrabajo" TEXT NOT NULL,
    "Referencia" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "EndodonciaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "PreparacionQuimicoMecanica_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ObturaciondeConductos" (
    "id" SERIAL NOT NULL,
    "Conducto" TEXT NOT NULL,
    "Tecnica" TEXT NOT NULL,
    "UltimaLongitudTrabajo" TEXT NOT NULL,
    "ConoMaestro" TEXT NOT NULL,
    "Referencia" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "EndodonciaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ObturaciondeConductos_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "RadiografiaEndodoncia" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Foto" TEXT NOT NULL,
    "Interpretacion" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "EndodonciaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "RadiografiaEndodoncia_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Operatoria" (
    "id" SERIAL NOT NULL,
    "Docente" TEXT NOT NULL,
    "MotivoConsulta" TEXT NOT NULL,
    "DiagnosticoDefinitivo" TEXT NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Operatoria_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Prueba" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Prueba_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "PruebaOperaria" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "PruebaId" INTEGER NOT NULL,
    "OperatoriaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "PruebaOperaria_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "TecnicaRadiografica" (
    "id" SERIAL NOT NULL,
    "NumeroPieza" TEXT NOT NULL,
    "Detalle" TEXT NOT NULL,
    "Tipo" TEXT NOT NULL,
    "OperatoriaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "TecnicaRadiografica_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "PlandeTrabajo" (
    "id" SERIAL NOT NULL,
    "Cantidad" TEXT NOT NULL,
    "TratamientoRestauracionconMaterialAdhesivo" TEXT NOT NULL,
    "PiezaNumero" TEXT NOT NULL,
    "TipodeMaterialRestaurador" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "OperatoriaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "PlandeTrabajo_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "Cirugia" (
    "id" SERIAL NOT NULL,
    "MotivoConsulta" TEXT NOT NULL,
    "DiagnosticoCIE11" TEXT NOT NULL,
    "Pronostico" TEXT NOT NULL,
    "PlandeTrabajo" TEXT NOT NULL,
    "Cirujano" TEXT NOT NULL,
    "Asistente" TEXT NOT NULL,
    "Circulante" TEXT NOT NULL,
    "HoradeInicioCx" TEXT NOT NULL,
    "HoradeTerminoCx" TEXT NOT NULL,
    "FechaAlta" TIMESTAMP(3) NOT NULL,
    "Observaciones" TEXT NOT NULL,
    "EvolucionDiaria" TEXT NOT NULL,
    "EstudianteaCargo" TEXT NOT NULL,
    "FacultativoaCargo" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "PacienteId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "Cirugia_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "RadiografiaCirugia" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Foto" TEXT NOT NULL,
    "Interpretacion" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "CirugiaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "RadiografiaCirugia_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "ConcentimientoCirugia" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Odontologo" TEXT NOT NULL,
    "Tipo" TEXT NOT NULL,
    "FirmaOdontologo" TEXT NOT NULL,
    "FirmaEstudiante" TEXT NOT NULL,
    "FirmaPaciente" TEXT NOT NULL,
    "FechaRegistro" TIMESTAMP(3) NOT NULL,
    "CirugiaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "ConcentimientoCirugia_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "InterpretacionRadiografica" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Detalle" TEXT NOT NULL,
    "CirugiaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "InterpretacionRadiografica_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "PlanTratamiento" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Detalle" TEXT NOT NULL,
    "CirugiaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "PlanTratamiento_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "InformeQuirurgico" (
    "id" SERIAL NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Detalle" TEXT NOT NULL,
    "CirugiaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "InformeQuirurgico_pkey" PRIMARY KEY ("id")
);

-- CreateTable
CREATE TABLE "EstadoPostquirurgico" (
    "id" SERIAL NOT NULL,
    "Fecha" TIMESTAMP(3) NOT NULL,
    "Nombre" TEXT NOT NULL,
    "Detalle" TEXT NOT NULL,
    "CirugiaId" INTEGER NOT NULL,
    "createdAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "updatedAt" TIMESTAMP(3) NOT NULL DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT "EstadoPostquirurgico_pkey" PRIMARY KEY ("id")
);

-- CreateIndex
CREATE UNIQUE INDEX "Empresa_Ruc_key" ON "Empresa"("Ruc");

-- CreateIndex
CREATE UNIQUE INDEX "Diagnostico_Codigo_key" ON "Diagnostico"("Codigo");

-- CreateIndex
CREATE UNIQUE INDEX "Usuario_Celular_key" ON "Usuario"("Celular");

-- CreateIndex
CREATE UNIQUE INDEX "Usuario_Correo_key" ON "Usuario"("Correo");

-- CreateIndex
CREATE UNIQUE INDEX "Usuario_NumDoc_key" ON "Usuario"("NumDoc");

-- CreateIndex
CREATE UNIQUE INDEX "Paciente_NumeroHistoriaClinica_key" ON "Paciente"("NumeroHistoriaClinica");

-- AddForeignKey
ALTER TABLE "Sede" ADD CONSTRAINT "Sede_EmpresaId_fkey" FOREIGN KEY ("EmpresaId") REFERENCES "Empresa"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Periodo" ADD CONSTRAINT "Periodo_SedeId_fkey" FOREIGN KEY ("SedeId") REFERENCES "Sede"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Usuario" ADD CONSTRAINT "Usuario_SedeId_fkey" FOREIGN KEY ("SedeId") REFERENCES "Sede"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Auditoria" ADD CONSTRAINT "Auditoria_UsuarioId_fkey" FOREIGN KEY ("UsuarioId") REFERENCES "Usuario"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Administrador" ADD CONSTRAINT "Administrador_UsuarioId_fkey" FOREIGN KEY ("UsuarioId") REFERENCES "Usuario"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Docente" ADD CONSTRAINT "Docente_UsuarioId_fkey" FOREIGN KEY ("UsuarioId") REFERENCES "Usuario"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Estudiante" ADD CONSTRAINT "Estudiante_UsuarioId_fkey" FOREIGN KEY ("UsuarioId") REFERENCES "Usuario"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Clase" ADD CONSTRAINT "Clase_idDocente_fkey" FOREIGN KEY ("idDocente") REFERENCES "Docente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Clase" ADD CONSTRAINT "Clase_idPeriodo_fkey" FOREIGN KEY ("idPeriodo") REFERENCES "Periodo"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Clase" ADD CONSTRAINT "Clase_idCurso_fkey" FOREIGN KEY ("idCurso") REFERENCES "Curso"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Integrante" ADD CONSTRAINT "Integrante_ClaseId_fkey" FOREIGN KEY ("ClaseId") REFERENCES "Clase"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Integrante" ADD CONSTRAINT "Integrante_EstudianteId_fkey" FOREIGN KEY ("EstudianteId") REFERENCES "Estudiante"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "SubCasoClinico" ADD CONSTRAINT "SubCasoClinico_CasoClinicoId_fkey" FOREIGN KEY ("CasoClinicoId") REFERENCES "CasoClinico"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "CasoDiente" ADD CONSTRAINT "CasoDiente_SubCasoClinicoId_fkey" FOREIGN KEY ("SubCasoClinicoId") REFERENCES "SubCasoClinico"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "CasoDiente" ADD CONSTRAINT "CasoDiente_DienteId_fkey" FOREIGN KEY ("DienteId") REFERENCES "Diente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Paciente" ADD CONSTRAINT "Paciente_SedeId_fkey" FOREIGN KEY ("SedeId") REFERENCES "Sede"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Paciente" ADD CONSTRAINT "Paciente_UsuarioId_fkey" FOREIGN KEY ("UsuarioId") REFERENCES "Usuario"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Cita" ADD CONSTRAINT "Cita_UsuarioId_fkey" FOREIGN KEY ("UsuarioId") REFERENCES "Usuario"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Cita" ADD CONSTRAINT "Cita_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Odontograma" ADD CONSTRAINT "Odontograma_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Mapeo" ADD CONSTRAINT "Mapeo_OdontogramaId_fkey" FOREIGN KEY ("OdontogramaId") REFERENCES "Odontograma"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Mapeo" ADD CONSTRAINT "Mapeo_CasodienteId_fkey" FOREIGN KEY ("CasodienteId") REFERENCES "CasoDiente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "CarasDiente" ADD CONSTRAINT "CarasDiente_MapeoId_fkey" FOREIGN KEY ("MapeoId") REFERENCES "Mapeo"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ExamenGeneral" ADD CONSTRAINT "ExamenGeneral_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Anamnesis" ADD CONSTRAINT "Anamnesis_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "DiagnosticoPresuntivo" ADD CONSTRAINT "DiagnosticoPresuntivo_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ExamenesAuxiliares" ADD CONSTRAINT "ExamenesAuxiliares_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "DiagnosticoDefinitivo" ADD CONSTRAINT "DiagnosticoDefinitivo_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Epicrisis" ADD CONSTRAINT "Epicrisis_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Interpretacion" ADD CONSTRAINT "Interpretacion_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "NotaEvolutiva" ADD CONSTRAINT "NotaEvolutiva_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "PlanyCronogramaCompleto" ADD CONSTRAINT "PlanyCronogramaCompleto_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ExamenEstomatologico" ADD CONSTRAINT "ExamenEstomatologico_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Endodoncia" ADD CONSTRAINT "Endodoncia_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ManifestacionEndodoncia" ADD CONSTRAINT "ManifestacionEndodoncia_EndodonciaId_fkey" FOREIGN KEY ("EndodonciaId") REFERENCES "Endodoncia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ManifestacionEndodoncia" ADD CONSTRAINT "ManifestacionEndodoncia_ManifestaciondelDolorId_fkey" FOREIGN KEY ("ManifestaciondelDolorId") REFERENCES "ManifestaciondelDolor"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Conductometria" ADD CONSTRAINT "Conductometria_EndodonciaId_fkey" FOREIGN KEY ("EndodonciaId") REFERENCES "Endodoncia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "PreparacionQuimicoMecanica" ADD CONSTRAINT "PreparacionQuimicoMecanica_EndodonciaId_fkey" FOREIGN KEY ("EndodonciaId") REFERENCES "Endodoncia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ObturaciondeConductos" ADD CONSTRAINT "ObturaciondeConductos_EndodonciaId_fkey" FOREIGN KEY ("EndodonciaId") REFERENCES "Endodoncia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "RadiografiaEndodoncia" ADD CONSTRAINT "RadiografiaEndodoncia_EndodonciaId_fkey" FOREIGN KEY ("EndodonciaId") REFERENCES "Endodoncia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Operatoria" ADD CONSTRAINT "Operatoria_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "PruebaOperaria" ADD CONSTRAINT "PruebaOperaria_PruebaId_fkey" FOREIGN KEY ("PruebaId") REFERENCES "Prueba"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "PruebaOperaria" ADD CONSTRAINT "PruebaOperaria_OperatoriaId_fkey" FOREIGN KEY ("OperatoriaId") REFERENCES "Operatoria"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "TecnicaRadiografica" ADD CONSTRAINT "TecnicaRadiografica_OperatoriaId_fkey" FOREIGN KEY ("OperatoriaId") REFERENCES "Operatoria"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "PlandeTrabajo" ADD CONSTRAINT "PlandeTrabajo_OperatoriaId_fkey" FOREIGN KEY ("OperatoriaId") REFERENCES "Operatoria"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "Cirugia" ADD CONSTRAINT "Cirugia_PacienteId_fkey" FOREIGN KEY ("PacienteId") REFERENCES "Paciente"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "RadiografiaCirugia" ADD CONSTRAINT "RadiografiaCirugia_CirugiaId_fkey" FOREIGN KEY ("CirugiaId") REFERENCES "Cirugia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "ConcentimientoCirugia" ADD CONSTRAINT "ConcentimientoCirugia_CirugiaId_fkey" FOREIGN KEY ("CirugiaId") REFERENCES "Cirugia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "InterpretacionRadiografica" ADD CONSTRAINT "InterpretacionRadiografica_CirugiaId_fkey" FOREIGN KEY ("CirugiaId") REFERENCES "Cirugia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "PlanTratamiento" ADD CONSTRAINT "PlanTratamiento_CirugiaId_fkey" FOREIGN KEY ("CirugiaId") REFERENCES "Cirugia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "InformeQuirurgico" ADD CONSTRAINT "InformeQuirurgico_CirugiaId_fkey" FOREIGN KEY ("CirugiaId") REFERENCES "Cirugia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE "EstadoPostquirurgico" ADD CONSTRAINT "EstadoPostquirurgico_CirugiaId_fkey" FOREIGN KEY ("CirugiaId") REFERENCES "Cirugia"("id") ON DELETE RESTRICT ON UPDATE CASCADE;
