const express = require('express');
const router = express.Router();
const AdministradorController = require('../controllers/administrador.controller');

// GET all Administradors
router.get('/', AdministradorController.getAllAdministradors);

// GET Administrador by id
router.get('/:id', AdministradorController.getAdministradorById);

// POST a new Administrador
router.post('/create', AdministradorController.createAdministrador);

// PUT update an existing Administrador
router.put('/update/:id', AdministradorController.updateAdministrador);

// DELETE an existing Administrador
// muy probable no considerar esta opción
// router.delete('/:id', AdministradorController.deleteAdministrador);

// para los filtros de Administrador
router.get('/usuario/:codigo', AdministradorController.getAdministradorByIdUsuario);

module.exports = router;
