const express = require('express');
const router = express.Router();
const auditoriaCtrl = require(
    '../controllers/auditoria.controller'
);

/* GET home page. */
router.get(
    '/',
    auditoriaCtrl.list
);
router.get(
    '/:id',
    auditoriaCtrl.get
);
router.post(
    '/create',
    auditoriaCtrl.create
);
router.put(
    '/update/:id',
    auditoriaCtrl.update
);
router.delete(
    '/:id',
    auditoriaCtrl.remove
);
// auditorias por fechas
router.get(
    '/search/fechas/:inicio/:fin',
    auditoriaCtrl.searchbyfechas
);

module.exports = router;
