const express = require('express');
const router = express.Router();
const CaraDienteController = require('../controllers/carasdiente.controller');

// GET all CaraDientes
router.get('/', CaraDienteController.getAllCaraDientes);

// GET CaraDiente by id
router.get('/:id', CaraDienteController.getCaraDienteById);

// POST a new CaraDiente
router.post('/create', CaraDienteController.createCaraDiente);

// PUT update an existing CaraDiente
router.put('/update/:id', CaraDienteController.updateCaraDiente);

// DELETE an existing CaraDiente
// muy probable no considerar esta opción
// router.delete('/:id', CaraDienteController.deleteCaraDiente);

// para los filtros de CaraDiente
// que historias creo el estudiante
router.get('/mapeo/:codigo', CaraDienteController.getCaraDienteByMapeo);

module.exports = router;
