const express = require('express');
const router = express.Router();
const CirugiaController = require('../controllers/cirugia.controller');

// GET all Cirugias
router.get('/', CirugiaController.getAllCirugias);

// GET Cirugia by id
router.get('/:id', CirugiaController.getCirugiaById);

// POST a new Cirugia
router.post('/create', CirugiaController.createCirugia);

// PUT update an existing Cirugia
router.put('/update/:id', CirugiaController.updateCirugia);

// DELETE an existing Cirugia
// muy probable no considerar esta opción
// router.delete('/:id', CirugiaController.deleteCirugia);

// para los filtros de Cirugia
router.get('/search/paciente/:codigo', CirugiaController.getCirugiaByPaciente);

module.exports = router;
