const express = require('express');
const router = express.Router();
const CitaController = require('../controllers/cita.controller');

// GET all Citas
router.get('/', CitaController.getAllCitas);

// GET Cita by id
router.get('/:id', CitaController.getCitaById);

// POST a new Cita
router.post('/create', CitaController.createCita);

// PUT update an existing Cita
router.put('/update/:id', CitaController.updateCita);

// DELETE an existing Cita
// muy probable no considerar esta opción
// router.delete('/:id', CitaController.deleteCita);

// para los filtrar citar del usuario
router.get('/search/sede/:lasede', CitaController.getCitaBySede);

// para los filtrar citar del usuario
router.get('/search/usuario/:codigo', CitaController.getCitaByUsuario);

// para los filtrar citas del paciente
router.get('/search/paciente/:codigo', CitaController.getCitaByPaciente);

// para los filtrar citas por fecha
router.get('/search/fecha/:lafecha/:empresa/:sede', CitaController.getCitaByFechaandSede);

module.exports = router;
