const express = require('express');
const router = express.Router();
const ClaseController = require('../controllers/clase.controller');

// GET all Clases
router.get('/', ClaseController.getAllClases);

// GET Clase by id
router.get('/:id', ClaseController.getClaseById);

// POST a new Clase
router.post('/create', ClaseController.createClase);

// PUT update an existing Clase
router.put('/update/:id', ClaseController.updateClase);

// DELETE an existing Clase
// muy probable no considerar esta opción
// router.delete('/:id', ClaseController.deleteClase);

// para los filtros de Clase
// busqueda de clases por periodo
router.get('/periodo/:codigo', ClaseController.periodoClase);

// busqueda de clases por periodo
router.get('/periodo-docente/:docente/:periodo', ClaseController.docenteperiodoClase);

// busqueda de clases por periodo
router.get('/periodo-docente-curso/:docente/:periodo/:curso', ClaseController.docenteperiodocursoClase);

module.exports = router;
