const express = require('express');
const router = express.Router();
const ConcentimientoCirugiaController = require('../controllers/concentimientocirugia.controller');

// GET all ConcentimientoCirugias
router.get('/', ConcentimientoCirugiaController.getAllConcentimientoCirugias);

// GET ConcentimientoCirugia by id
router.get('/:id', ConcentimientoCirugiaController.getConcentimientoCirugiaById);

// POST a new ConcentimientoCirugia
router.post('/create', ConcentimientoCirugiaController.createConcentimientoCirugia);

// PUT update an existing ConcentimientoCirugia
router.put('/update/:id', ConcentimientoCirugiaController.updateConcentimientoCirugia);

// DELETE an existing ConcentimientoCirugia
// muy probable no considerar esta opción
// router.delete('/:id', ConcentimientoCirugiaController.deleteConcentimientoCirugia);

// para los filtros de ConcentimientoCirugia
router.get('/search/cirugia/:codigo', ConcentimientoCirugiaController.getConcentimientoCirugiaByCirugia);

module.exports = router;
