const express = require('express');
const router = express.Router();
const ConductometriaController = require('../controllers/conductometria.controller');

// GET all Conductometrias
router.get('/', ConductometriaController.getAllConductometrias);

// GET Conductometria by id
router.get('/:id', ConductometriaController.getConductometriaById);

// POST a new Conductometria
router.post('/create', ConductometriaController.createConductometria);

// PUT update an existing Conductometria
router.put('/update/:id', ConductometriaController.updateConductometria);

// DELETE an existing Conductometria
// muy probable no considerar esta opción
// router.delete('/:id', ConductometriaController.deleteConductometria);

// para los filtros de Conductometria
router.get('/search/endodoncia/:codigo', ConductometriaController.getConductometriaByEndodoncia);

module.exports = router;
