const express = require('express');
const router = express.Router();
const CursoController = require('../controllers/curso.controller');

// GET all Cursos
router.get('/', CursoController.getAllCursos);

// GET Curso by id
router.get('/:id', CursoController.getCursoById);

// POST a new Curso
router.post('/create', CursoController.createCurso);

// PUT update an existing Curso
router.put('/update/:id', CursoController.updateCurso);

// DELETE an existing Curso
// muy probable no considerar esta opción
// router.delete('/:id', CursoController.deleteCurso);

module.exports = router;
