const express = require('express');
const router = express.Router();
const DiagnosticoController = require('../controllers/diagnostico.controller');

// GET all Diagnosticos
router.get('/', DiagnosticoController.getAllDiagnosticos);

// GET Diagnostico by id
router.get('/:id', DiagnosticoController.getDiagnosticoById);

// POST a new Diagnostico
router.post('/create', DiagnosticoController.createDiagnostico);

// PUT update an existing Diagnostico
router.put('/update/:id', DiagnosticoController.updateDiagnostico);

// DELETE an existing Diagnostico
// muy probable no considerar esta opción
// router.delete('/:id', DiagnosticoController.deleteDiagnostico);

module.exports = router;
