const express = require('express');
const router = express.Router();
const DiagnosticoDefinitivoController = require('../controllers/diagnosticodefintivo.controller');

// GET all DiagnosticoDefinitivos
router.get('/', DiagnosticoDefinitivoController.getAllDiagnosticoDefinitivos);

// GET DiagnosticoDefinitivo by id
router.get('/search/:id', DiagnosticoDefinitivoController.getDiagnosticoDefinitivoById);

// POST a new DiagnosticoDefinitivo
router.post('/create', DiagnosticoDefinitivoController.createDiagnosticoDefinitivo);

// PUT update an existing DiagnosticoDefinitivo
router.put('/update/:id', DiagnosticoDefinitivoController.updateDiagnosticoDefinitivo);

// DELETE an existing DiagnosticoDefinitivo
// muy probable no considerar esta opción
// router.delete('/:id', DiagnosticoDefinitivoController.deleteDiagnosticoDefinitivo);

// para los filtros de DiagnosticoDefinitivo
router.get('/search/paciente/:codigo', DiagnosticoDefinitivoController.getDiagnosticoDefinitivoByPaciente);

module.exports = router;
