const express = require('express');
const router = express.Router();
const EmpresaController = require('../controllers/empresa.controller');

// GET all empresas
router.get('/', EmpresaController.getAllEmpresas);

// GET empresa by id
router.get('/:id', EmpresaController.getEmpresaById);

// POST a new empresa
router.post('/create', EmpresaController.createEmpresa);

// PUT update an existing empresa
router.put('/update/:id', EmpresaController.updateEmpresa);

// DELETE an existing empresa
// muy probable no considerar esta opción
// router.delete('/:id', EmpresaController.deleteEmpresa);

module.exports = router;
